/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import java.util.Arrays;

public class LogBaseGbInfo
extends Message {
    private String epc;
    private byte[] bEpc;
    private String tid;
    private byte[] bTid;
    private int pc;
    private int antId;
    private int rssi;
    private int result;
    private String userdata;
    private byte[] bUser;
    private String readerSerialNumber;

    public String getEpc() {
        return this.epc;
    }

    public void setEpc(String epc) {
        this.epc = epc;
    }

    public byte[] getbEpc() {
        return this.bEpc;
    }

    public void setbEpc(byte[] bEpc) {
        this.bEpc = bEpc;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public byte[] getbTid() {
        return this.bTid;
    }

    public void setbTid(byte[] bTid) {
        this.bTid = bTid;
    }

    public int getPc() {
        return this.pc;
    }

    public void setPc(int pc) {
        this.pc = pc;
    }

    public int getAntId() {
        return this.antId;
    }

    public void setAntId(int antId) {
        this.antId = antId;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        this.result = result;
    }

    public String getUserdata() {
        return this.userdata;
    }

    public void setUserdata(String userdata) {
        this.userdata = userdata;
    }

    public byte[] getbUser() {
        return this.bUser;
    }

    public void setbUser(byte[] bUser) {
        this.bUser = bUser;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int epcLen = buffer.getIntUnsigned(16);
            this.bEpc = new byte[epcLen];
            this.bEpc = buffer.get(this.bEpc);
            if (this.bEpc.length > 0) {
                this.epc = HexUtils.bytes2HexString(this.bEpc);
            }
            this.pc = buffer.getIntUnsigned(16);
            this.antId = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int index = buffer.getIntUnsigned(8);
                switch (index) {
                    case 1: {
                        this.rssi = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.result = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        int tidLen = buffer.getIntUnsigned(16);
                        this.bTid = new byte[tidLen];
                        if (tidLen <= 0) break;
                        this.bTid = buffer.get(this.bTid);
                        this.tid = HexUtils.bytes2HexString(this.bTid);
                        break;
                    }
                    case 4: {
                        int userLen = buffer.getIntUnsigned(16);
                        this.bUser = new byte[userLen];
                        if (userLen <= 0) break;
                        this.bUser = buffer.get(this.bUser);
                        this.userdata = HexUtils.bytes2HexString(this.bUser);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return "LogBaseGbInfo{epc='" + this.epc + '\'' + ", bEpc=" + Arrays.toString(this.bEpc) + ", tid='" + this.tid + '\'' + ", bTid=" + Arrays.toString(this.bTid) + ", pc=" + this.pc + ", antId=" + this.antId + ", rssi=" + this.rssi + ", result=" + this.result + ", userdata='" + this.userdata + '\'' + ", bUser=" + Arrays.toString(this.bUser) + ", readerSerialNumber='" + this.readerSerialNumber + '\'' + '}';
    }

    public String toHexString() {
        return "HexString{" + HexUtils.bytes2HexString(this.cData) + '}';
    }
}

