/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetFreqRange
extends Message {
    private int freqRangeIndex = Integer.MAX_VALUE;

    public MsgBaseGetFreqRange() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)4;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetFreqRange(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.freqRangeIndex = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFreqRangeIndex() {
        return this.freqRangeIndex;
    }

    public void setFreqRangeIndex(int freqRangeIndex) {
        this.freqRangeIndex = freqRangeIndex;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.freqRangeIndex, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length == 1) {
            this.freqRangeIndex = this.cData[0];
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetFreqRange{freqRangeIndex=" + this.freqRangeIndex + '}';
    }
}

