/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans;

import android.util.Log;
import com.rfid.serialport.SerialPort;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;

public class MessageTran {
    private InputStream mInStream = null;
    private OutputStream mOutStream = null;
    private SerialPort mSerialPort = null;
    private boolean connected = false;

    public boolean isOpen() {
        return this.connected;
    }

    public int open(String ComPort, int BaudRate) {
        try {
            this.mSerialPort = new SerialPort(new File(ComPort), BaudRate, 0);
        }
        catch (SecurityException securityException) {
        }
        catch (IOException iOException) {
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
        if (this.mSerialPort != null) {
            this.mInStream = this.mSerialPort.getInputStream();
            this.mOutStream = this.mSerialPort.getOutputStream();
            this.connected = true;
            return 0;
        }
        return -1;
    }

    public int close() {
        if (this.mInStream != null) {
            try {
                if (this.mSerialPort != null) {
                    this.mSerialPort.close();
                    this.mSerialPort = null;
                }
                this.mInStream.close();
                this.mOutStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.connected = false;
        return 0;
    }

    public byte[] Read() {
        if (!this.connected) {
            return null;
        }
        try {
            byte[] RecvBuff = new byte[2560];
            int len = this.mInStream.read(RecvBuff);
            if (len > 0) {
                byte[] buff = new byte[len];
                System.arraycopy(RecvBuff, 0, buff, 0, len);
                Log.d((String)"Recv", (String)this.bytesToHexString(buff, 0, buff.length));
                return buff;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public int Write(byte[] buffer) {
        if (!this.connected) {
            return -1;
        }
        if (buffer.length != (buffer[0] & 0xFF) + 1) {
            return -1;
        }
        try {
            byte[] cmd = new byte[(buffer[0] & 0xFF) + 1];
            System.arraycopy(buffer, 0, cmd, 0, cmd.length);
            this.mOutStream.flush();
            this.mOutStream.write(cmd);
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String bytesToHexString(byte[] src, int offset, int length) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            if (src == null || src.length <= 0) {
                return null;
            }
            for (int i = offset; i < length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() == 1) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            return stringBuilder.toString().toUpperCase();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public byte[] hexStringToBytes(String hexString) {
        try {
            if (hexString == null || hexString.equals("")) {
                return null;
            }
            hexString = hexString.toUpperCase();
            int length = hexString.length() / 2;
            char[] hexChars = hexString.toCharArray();
            byte[] d = new byte[length];
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = (byte)(this.charToByte(hexChars[pos]) << 4 | this.charToByte(hexChars[pos + 1]));
            }
            return d;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

