/*
 * Decompiled with CFR 0.152.
 */
package com.android.usbserial.client;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import com.android.usbserial.client.OnUsbSerialDeviceListener;
import com.android.usbserial.driver.UsbSerialDriver;
import com.android.usbserial.driver.UsbSerialPort;
import com.android.usbserial.driver.UsbSerialProber;
import com.android.usbserial.util.SerialInputOutputManager;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.OnUsbSerialStateListener;
import com.gg.reader.api.protocol.gx.Message;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidUsbSerialClient
extends CommunicationInterface
implements SerialInputOutputManager.Listener {
    private static final String ACTION_USB_PERMISSION = "com.android.gx.USB_PERMISSION";
    private UsbManager mUsbManager;
    private UsbSerialPort usbSerialPort;
    private SerialInputOutputManager mSerialIoManager;
    private Handler mHandler;
    public OnUsbSerialDeviceListener deviceListener;
    public OnUsbSerialStateListener stateListener;
    private Context mContext;
    private int mBaudRate = 115200;
    private int writeTimeout = 100;
    private String mUsbName;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (AndroidUsbSerialClient.ACTION_USB_PERMISSION.equals(action)) {
                context.unregisterReceiver((BroadcastReceiver)this);
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false) && device != null) {
                        AndroidUsbSerialClient.this.openDevice();
                    } else {
                        AndroidUsbSerialClient.this.onConnectFailed();
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mUsbStateChange = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                if (AndroidUsbSerialClient.this.stateListener != null) {
                    AndroidUsbSerialClient.this.stateListener.onDeviceAttached();
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && AndroidUsbSerialClient.this.stateListener != null) {
                AndroidUsbSerialClient.this.stateListener.onDeviceDetached();
            }
        }
    };

    public UsbDevice getUsbDevice() {
        return this.usbSerialPort.getDriver().getDevice();
    }

    public int getBaudRate() {
        return this.mBaudRate;
    }

    public void setBaudRate(int mBaudRate) {
        this.mBaudRate = mBaudRate;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public String getUsbName() {
        return this.mUsbName;
    }

    public void setmUsbName(String mUsbName) {
        this.mUsbName = mUsbName;
    }

    public static Map<String, AndroidUsbSerialClient> getUsbDevicesMap(Context context) {
        UsbManager mUsbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (mUsbManager == null) {
            return null;
        }
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(mUsbManager);
        HashMap<String, AndroidUsbSerialClient> driverMap = new HashMap<String, AndroidUsbSerialClient>();
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            for (UsbSerialPort port : ports) {
                UsbDevice device = port.getDriver().getDevice();
                String s = driver.getDriverName() + "_vid_" + device.getVendorId() + "&pid_" + device.getProductId();
                AndroidUsbSerialClient usbSerialClient = new AndroidUsbSerialClient(port, context, mUsbManager, s);
                driverMap.put(s, usbSerialClient);
            }
        }
        return driverMap;
    }

    public static Map<String, AndroidUsbSerialClient> getUsbDevicesMap(Context context, int vid, int pid) {
        UsbManager mUsbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (mUsbManager == null) {
            return null;
        }
        List<UsbSerialDriver> drivers = UsbSerialProber.getDefaultProber().findAllDrivers(mUsbManager);
        HashMap<String, AndroidUsbSerialClient> driverMap = new HashMap<String, AndroidUsbSerialClient>();
        for (UsbSerialDriver driver : drivers) {
            List<UsbSerialPort> ports = driver.getPorts();
            for (UsbSerialPort port : ports) {
                UsbDevice device = port.getDriver().getDevice();
                if (device.getVendorId() != vid || device.getProductId() != pid) continue;
                String s = driver.getDriverName() + "_vid_" + device.getVendorId() + "&pid_" + device.getProductId();
                AndroidUsbSerialClient usbSerialClient = new AndroidUsbSerialClient(port, context, mUsbManager, s);
                driverMap.put(s, usbSerialClient);
            }
        }
        return driverMap;
    }

    public static List<AndroidUsbSerialClient> getUsbDevicesList(Context context) {
        Map<String, AndroidUsbSerialClient> usbDevicesMap = AndroidUsbSerialClient.getUsbDevicesMap(context);
        if (usbDevicesMap == null) {
            return null;
        }
        return new ArrayList<AndroidUsbSerialClient>(usbDevicesMap.values());
    }

    public static List<AndroidUsbSerialClient> getUsbDevicesList(Context context, int vid, int pid) {
        Map<String, AndroidUsbSerialClient> usbDevicesMap = AndroidUsbSerialClient.getUsbDevicesMap(context, vid, pid);
        if (usbDevicesMap == null) {
            return null;
        }
        return new ArrayList<AndroidUsbSerialClient>(usbDevicesMap.values());
    }

    private AndroidUsbSerialClient(UsbSerialPort serialPort, Context context, UsbManager usbManager, String usbName) {
        this.usbSerialPort = serialPort;
        this.mContext = context;
        this.mUsbManager = usbManager;
        this.mUsbName = usbName;
    }

    private void hasPermission() {
        this.mHandler = new Handler(this.mContext.getMainLooper());
        if (!this.mUsbManager.hasPermission(this.getUsbDevice())) {
            PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            this.mContext.registerReceiver(this.mUsbReceiver, filter);
            this.mUsbManager.requestPermission(this.getUsbDevice(), permissionIntent);
        } else {
            this.openDevice();
        }
    }

    private void openDevice() {
        UsbDeviceConnection connection = this.mUsbManager.openDevice(this.getUsbDevice());
        if (connection == null) {
            this.onConnectFailed();
            return;
        }
        try {
            this.usbSerialPort.open(connection);
            this.usbSerialPort.setParameters(this.mBaudRate, 8, 1, 0);
            this.mSerialIoManager = new SerialInputOutputManager(this.usbSerialPort, this);
            this.keepReceived = true;
            this.mSerialIoManager.start();
            this.startProcess();
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (AndroidUsbSerialClient.this.deviceListener != null) {
                        AndroidUsbSerialClient.this.deviceListener.onDeviceConnected();
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void onConnectFailed() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AndroidUsbSerialClient.this.deviceListener != null) {
                    AndroidUsbSerialClient.this.deviceListener.onDeviceConnectFailed();
                }
            }
        });
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        this.hasPermission();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.keepReceived = false;
        if (this.usbSerialPort != null) {
            try {
                this.mSerialIoManager.stop();
                this.usbSerialPort.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notify();
                this.ringBuffer.Clear();
            }
        }
    }

    @Override
    public void send(byte[] data) {
        if (this.usbSerialPort != null) {
            int maxPacketSize = this.usbSerialPort.getWriteEndpoint().getMaxPacketSize();
            int pack = data.length / maxPacketSize;
            if (data.length % maxPacketSize > 0) {
                ++pack;
            }
            for (int i = 0; i < pack; ++i) {
                byte[] newBuffer = Arrays.copyOfRange(data, i * maxPacketSize, maxPacketSize + i * maxPacketSize);
                try {
                    this.usbSerialPort.write(newBuffer, this.writeTimeout);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void send(Message msg) {
        try {
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewData(byte[] data) {
        try {
            Object object = this.lockRingBuffer;
            synchronized (object) {
                while (data.length + this.ringBuffer.getDataCount() > 0x100000) {
                    this.lockRingBuffer.wait(10000L);
                }
                this.ringBuffer.WriteBuffer(data, 0, data.length);
                this.lockRingBuffer.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onRunError(Exception e) {
    }

    public void registerUsbState(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        IntentFilter usbFilter = new IntentFilter();
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbStateChange, usbFilter);
    }

    public void unregisterState(Context context) {
        context.unregisterReceiver(this.mUsbStateChange);
    }
}

