/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseSetBaseband
extends Message {
    private int baseSpeed = Integer.MAX_VALUE;
    private int qValue = Integer.MAX_VALUE;
    private int session = Integer.MAX_VALUE;
    private int inventoryFlag = Integer.MAX_VALUE;

    public MsgBaseSetBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)11;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.baseSpeed = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.qValue = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        this.session = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 4: {
                        this.inventoryFlag = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(int baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    public int getqValue() {
        return this.qValue;
    }

    public void setqValue(int qValue) {
        this.qValue = qValue;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (Integer.MAX_VALUE != this.baseSpeed) {
            buffer.putInt(1, 8);
            buffer.putLong(this.baseSpeed, 8);
        }
        if (Integer.MAX_VALUE != this.qValue) {
            buffer.putInt(2, 8);
            buffer.putLong(this.qValue, 8);
        }
        if (Integer.MAX_VALUE != this.session) {
            buffer.putInt(3, 8);
            buffer.putLong(this.session, 8);
        }
        if (Integer.MAX_VALUE != this.inventoryFlag) {
            buffer.putInt(4, 8);
            buffer.putLong(this.inventoryFlag, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Parameter not supported.");
                this.put((byte)2, "Q value parameter error.");
                this.put((byte)3, "Session parameter error.");
                this.put((byte)4, "Inventory parameter error.");
                this.put((byte)5, "Other error.");
                this.put((byte)6, "Save failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

