/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseSetResidenceTime
extends Message {
    private Long antResidenceTime = Long.MAX_VALUE;
    private Long frqResidenceTime = Long.MAX_VALUE;

    public MsgBaseSetResidenceTime() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-32;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetResidenceTime(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.antResidenceTime = buffer.getLongUnsigned(16);
                        break;
                    }
                    case 2: {
                        this.frqResidenceTime = buffer.getLongUnsigned(16);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntResidenceTime() {
        return this.antResidenceTime;
    }

    public void setAntResidenceTime(Long antResidenceTime) {
        this.antResidenceTime = antResidenceTime;
    }

    public Long getFrqResidenceTime() {
        return this.frqResidenceTime;
    }

    public void setFrqResidenceTime(Long frqResidenceTime) {
        this.frqResidenceTime = frqResidenceTime;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (Integer.MAX_VALUE != this.antResidenceTime) {
            buffer.putInt(1, 8);
            buffer.putLong(this.antResidenceTime, 16);
        }
        if (Integer.MAX_VALUE != this.frqResidenceTime) {
            buffer.putInt(2, 8);
            buffer.putLong(this.frqResidenceTime, 16);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Mode parameter error.");
                this.put((byte)2, "Other parameter error.");
                this.put((byte)3, "Save Failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

