/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Arrays;
import java.util.Hashtable;

public class MsgTestChip
extends Message {
    private Integer address;
    private byte[] dataContent;
    private String hexDataContent;

    public MsgTestChip() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)49;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Integer getAddress() {
        return this.address;
    }

    public void setAddress(Integer address) {
        this.address = address;
    }

    public byte[] getDataContent() {
        return this.dataContent;
    }

    public void setDataContent(byte[] dataContent) {
        this.dataContent = dataContent;
    }

    public String getHexDataContent() {
        return this.hexDataContent;
    }

    public void setHexDataContent(String hexDataContent) {
        this.hexDataContent = hexDataContent;
        if (!StringUtils.isNullOfEmpty(hexDataContent)) {
            this.dataContent = HexUtils.hexString2Bytes(this.hexDataContent);
        }
    }

    public MsgTestChip(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.address = buffer.getIntUnsigned(16);
            this.dataContent = buffer.get(new byte[2]);
            if (null != this.dataContent && this.dataContent.length > 0) {
                this.hexDataContent = HexUtils.bytes2HexString(this.dataContent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (Integer.MAX_VALUE != this.address) {
            buffer.putLong(this.address.intValue(), 16);
        }
        if (null != this.dataContent) {
            buffer.put(this.dataContent);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Other Error");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
            if (this.address == 770) {
                BitBuffer buffer = BitBuffer.wrap(this.cData);
                buffer.position(0);
                this.hexDataContent = HexUtils.bytes2HexString(buffer.get(new byte[4]));
                this.setRtCode((byte)0);
            }
        }
    }

    public String toString() {
        return "MsgTestChip{address=" + this.address + ", dataContent=" + Arrays.toString(this.dataContent) + ", hexDataContent='" + this.hexDataContent + '\'' + '}';
    }
}

