/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEncipheredData;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseSafeCertification
extends Message {
    private int token1 = Integer.MAX_VALUE;
    private int token2result = Integer.MAX_VALUE;
    private ParamEncipheredData paramEncipheredData;
    private String key;

    public MsgBaseSafeCertification() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-16;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSafeCertification(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(64);
                        byte[] paramData = new byte[len];
                        if (len <= 0) break;
                        byte[] bytes = buffer.get(paramData);
                        this.token1 = HexUtils.bytes2Int(bytes);
                        break;
                    }
                    case 2: {
                        this.token2result = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.paramEncipheredData = new ParamEncipheredData(paramData);
                        break;
                    }
                    case 4: {
                        int length = buffer.getIntUnsigned(8);
                        this.key = buffer.getString(length * 8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getToken1() {
        return this.token1;
    }

    public void setToken1(int token1) {
        this.token1 = token1;
    }

    public int getToken2result() {
        return this.token2result;
    }

    public void setToken2result(int token2result) {
        this.token2result = token2result;
    }

    public ParamEncipheredData getParamEncipheredData() {
        return this.paramEncipheredData;
    }

    public void setParamEncipheredData(ParamEncipheredData paramEncipheredData) {
        this.paramEncipheredData = paramEncipheredData;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.token1) {
                buffer.putInt(1, 8);
                buffer.putInt(this.token1, 64);
            }
            if (Integer.MAX_VALUE != this.token2result) {
                buffer.putInt(2, 8);
                buffer.put(this.token2result, 8);
            }
            if (null != this.paramEncipheredData) {
                buffer.putInt(3, 8);
                byte[] tmpByte = this.paramEncipheredData.toBytes();
                buffer.put(tmpByte);
            }
            if (!StringUtils.isNullOfEmpty(this.key)) {
                buffer.putInt(4, 8);
                buffer.put(this.key.length(), 16);
                buffer.put(this.key);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

