/*
 * Decompiled with CFR 0.152.
 */
package com.rfid.trans;

import android.os.SystemClock;
import android.util.Log;
import com.rfid.trans.MessageTran;
import com.rfid.trans.ReadTag;
import com.rfid.trans.TagCallback;

public class BaseReader {
    private MessageTran msg = new MessageTran();
    private long maxScanTime = 2000L;
    private int[] recvLength = new int[1];
    private byte[] recvBuff = new byte[20000];
    private int logswitch = 0;
    private TagCallback callback;
    private String resultError = "";
    private static final String TAG = "LJH###################";

    private void getCRC(byte[] data, int Len) {
        try {
            int current_crc_value = 65535;
            for (int i = 0; i < Len; ++i) {
                current_crc_value ^= data[i] & 0xFF;
                for (int j = 0; j < 8; ++j) {
                    if ((current_crc_value & 1) != 0) {
                        current_crc_value = current_crc_value >> 1 ^ 0x8408;
                        continue;
                    }
                    current_crc_value >>= 1;
                }
            }
            data[i++] = (byte)(current_crc_value & 0xFF);
            data[i] = (byte)(current_crc_value >> 8 & 0xFF);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean CheckCRC(byte[] data, int len) {
        try {
            byte[] daw = new byte[256];
            System.arraycopy(data, 0, daw, 0, len);
            this.getCRC(daw, len);
            return 0 == daw[len + 1] && 0 == daw[len];
        }
        catch (Exception e) {
            return false;
        }
    }

    public String bytesToHexString(byte[] src, int offset, int length) {
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            if (src == null || src.length <= 0) {
                return null;
            }
            for (int i = offset; i < length; ++i) {
                int v = src[i] & 0xFF;
                String hv = Integer.toHexString(v);
                if (hv.length() == 1) {
                    stringBuilder.append(0);
                }
                stringBuilder.append(hv);
            }
            return stringBuilder.toString().toUpperCase();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public byte[] hexStringToBytes(String hexString) {
        try {
            if (hexString == null || hexString.equals("")) {
                return null;
            }
            hexString = hexString.toUpperCase();
            int length = hexString.length() / 2;
            char[] hexChars = hexString.toCharArray();
            byte[] d = new byte[length];
            for (int i = 0; i < length; ++i) {
                int pos = i * 2;
                d[i] = (byte)(this.charToByte(hexChars[pos]) << 4 | this.charToByte(hexChars[pos + 1]));
            }
            return d;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public void SetCallBack(TagCallback callback) {
        this.callback = callback;
    }

    public int Connect(String ComPort, int BaudRate, int LogFlag) {
        this.logswitch = LogFlag;
        return this.msg.open(ComPort, BaudRate);
    }

    public int DisConnect() {
        return this.msg.close();
    }

    private int SendCMD(byte[] CMD) {
        if (this.logswitch == 1) {
            Log.d((String)"Send", (String)this.bytesToHexString(CMD, 0, (CMD[0] & 0xFF) + 1));
        }
        return this.msg.Write(CMD);
    }

    private int GetCMDData(byte[] data, int[] Nlen, int cmd, int endTime) {
        int Count = 0;
        byte[] btArray = new byte[2000];
        int btLength = 0;
        long beginTime = System.currentTimeMillis();
        try {
            while (System.currentTimeMillis() - beginTime < (long)endTime) {
                byte[] buffer = this.msg.Read();
                if (buffer == null || (Count = buffer.length) == 0) continue;
                byte[] daw = new byte[Count + btLength];
                System.arraycopy(btArray, 0, daw, 0, btLength);
                System.arraycopy(buffer, 0, daw, btLength, Count);
                int index = 0;
                while (daw.length - index > 4) {
                    if ((daw[index] & 0xFF) >= 4 && ((daw[index + 2] & 0xFF) == cmd || (daw[index + 3] & 0xFF) == 254 && (daw[index + 2] & 0xFF) == 0)) {
                        int len = daw[index] & 0xFF;
                        if (daw.length < index + len + 1) break;
                        byte[] epcArr = new byte[len + 1];
                        System.arraycopy(daw, index, epcArr, 0, epcArr.length);
                        if (this.CheckCRC(epcArr, epcArr.length)) {
                            System.arraycopy(epcArr, 0, data, 0, epcArr.length);
                            Nlen[0] = epcArr.length + 1;
                            return 0;
                        }
                        ++index;
                        continue;
                    }
                    ++index;
                }
                if (daw.length > index) {
                    btLength = daw.length - index;
                    System.arraycopy(daw, index, btArray, 0, btLength);
                    continue;
                }
                btLength = 0;
            }
        }
        catch (Exception e) {
            e.toString();
        }
        return 48;
    }

    private int GetInventoryData(byte ComAddr, int cmd, byte[] epcdata, int[] epcNum, int[] dlen, int Scantime) {
        boolean crccheck = false;
        epcNum[0] = 0;
        dlen[0] = 0;
        int Count = 0;
        byte[] btArray = new byte[2000];
        int btLength = 0;
        long beginTime = SystemClock.elapsedRealtime();
        try {
            do {
                byte[] buffer;
                if ((buffer = this.msg.Read()) == null || (Count = buffer.length) == 0) continue;
                byte[] daw = new byte[Count + btLength];
                System.arraycopy(btArray, 0, daw, 0, btLength);
                System.arraycopy(buffer, 0, daw, btLength, Count);
                int index = 0;
                while (daw.length - index > 5) {
                    if ((ComAddr & 0xFF) == 255) {
                        ComAddr = 0;
                    }
                    if ((daw[index] & 0xFF) >= 5 && daw[index + 1] == ComAddr && (daw[index + 2] & 0xFF) == cmd) {
                        int len = daw[index] & 0xFF;
                        if (daw.length < index + len + 1) break;
                        byte[] epcArr = new byte[len + 1];
                        System.arraycopy(daw, index, epcArr, 0, epcArr.length);
                        if (this.CheckCRC(epcArr, epcArr.length)) {
                            crccheck = true;
                            int nLen = (epcArr[0] & 0xFF) + 1;
                            index += nLen;
                            int status = epcArr[3] & 0xFF;
                            if (status == 1 || status == 2 || status == 3 || status == 4) {
                                int num = epcArr[5] & 0xFF;
                                if (num > 0) {
                                    int m = 6;
                                    for (int nm = 0; nm < num; ++nm) {
                                        int epclen = epcArr[m] & 0xFF;
                                        System.arraycopy(epcArr, m, epcdata, dlen[0], epclen + 2);
                                        epcNum[0] = epcNum[0] + 1;
                                        dlen[0] = dlen[0] + (epclen + 2);
                                        if (this.callback != null && epclen > 0) {
                                            ReadTag tag = new ReadTag();
                                            tag.antId = epcArr[4] & 0xFF;
                                            epclen = epcArr[m] & 0xFF;
                                            byte[] btArr = new byte[epclen];
                                            System.arraycopy(epcArr, m + 1, btArr, 0, btArr.length);
                                            tag.epcId = this.bytesToHexString(btArr, 0, btArr.length);
                                            tag.rssi = epcArr[m + 1 + epclen] & 0xFF;
                                            this.callback.tagCallback(tag);
                                        }
                                        m = m + 2 + epclen;
                                    }
                                }
                                if (status != 1 && status != 2) continue;
                                if (epcNum[0] > 0) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (this.callback != null) {
                                this.callback.tagCallbackFailed(status);
                            }
                            return status;
                        }
                        ++index;
                        if (this.callback != null) {
                            if (crccheck) {
                                this.callback.tagCallbackFailed(1);
                            } else {
                                this.callback.tagCallbackFailed(2);
                            }
                        }
                        Log.d((String)"errorrinfo", (String)"1111");
                        crccheck = false;
                        continue;
                    }
                    ++index;
                    if (this.callback != null) {
                        if (crccheck) {
                            this.callback.tagCallbackFailed(1);
                        } else {
                            this.callback.tagCallbackFailed(2);
                        }
                        Log.d((String)"errorrinfo", (String)"0000");
                    }
                    crccheck = false;
                }
                if (daw.length > index) {
                    btLength = daw.length - index;
                    System.arraycopy(daw, index, btArray, 0, btLength);
                    continue;
                }
                btLength = 0;
            } while (SystemClock.elapsedRealtime() - beginTime < (long)(Scantime * 100 + 3000));
        }
        catch (Exception e) {
            this.resultError = e.toString();
            Log.d((String)"error", (String)this.resultError);
        }
        if (this.callback != null) {
            this.callback.tagCallbackFailed(48);
        }
        return 48;
    }

    public int GetReaderInformation(byte[] ComAddr, byte[] TVersionInfo, byte[] ReaderType, byte[] TrType, byte[] band, byte[] dmaxfre, byte[] dminfre, byte[] powerdBm, byte[] ScanTime, byte[] Ant, byte[] BeepEn, byte[] OutputRep, byte[] CheckAnt) {
        byte[] buffer = new byte[5];
        buffer[0] = 4;
        buffer[1] = ComAddr[0];
        buffer[2] = 33;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 33, 1000);
        if (result == 0) {
            ComAddr[0] = this.recvBuff[1];
            TVersionInfo[0] = this.recvBuff[4];
            TVersionInfo[1] = this.recvBuff[5];
            ReaderType[0] = this.recvBuff[6];
            TrType[0] = this.recvBuff[7];
            dmaxfre[0] = (byte)(this.recvBuff[8] & 0x3F);
            dminfre[0] = (byte)(this.recvBuff[9] & 0x3F);
            band[0] = (byte)((this.recvBuff[8] & 0xC0) >> 4 | (this.recvBuff[9] & 0xC0) >> 6);
            powerdBm[0] = this.recvBuff[10];
            ScanTime[0] = this.recvBuff[11];
            this.maxScanTime = (ScanTime[0] & 0xFF) * 100;
            Ant[0] = this.recvBuff[12];
            BeepEn[0] = this.recvBuff[13];
            OutputRep[0] = this.recvBuff[14];
            CheckAnt[0] = this.recvBuff[15];
            return 0;
        }
        return 48;
    }

    public int SetInventoryScanTime(byte ComAddr, byte ScanTime) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 37;
        buffer[3] = ScanTime;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 37, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetPowerMode(byte ComAddr, byte[] powermode) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 107;
        buffer[3] = powermode[0];
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 107, 500);
        if (result == 0) {
            if (powermode[0] == 0) {
                powermode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int Inventory_G2(byte ComAddr, byte QValue, byte Session, byte AdrTID, byte LenTID, byte Target, byte Ant, int Scantime, byte[] pOUcharIDList, int[] pOUcharTagNum, int[] pListLen) {
        byte[] buffer = null;
        if (LenTID == 0) {
            buffer = new byte[10];
            buffer[0] = 9;
            buffer[1] = ComAddr;
            buffer[2] = 1;
            buffer[3] = QValue;
            buffer[4] = Session;
            buffer[5] = Target;
            buffer[6] = Ant;
            buffer[7] = (byte)Scantime;
        } else {
            buffer = new byte[12];
            buffer[0] = 11;
            buffer[1] = ComAddr;
            buffer[2] = 1;
            buffer[3] = QValue;
            buffer[4] = Session;
            buffer[5] = AdrTID;
            buffer[6] = LenTID;
            buffer[7] = Target;
            buffer[8] = Ant;
            buffer[9] = (byte)Scantime;
        }
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        return this.GetInventoryData(ComAddr, 1, pOUcharIDList, pOUcharTagNum, pListLen, Scantime);
    }

    public int SetRfPower(byte ComAddr, byte power) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 47;
        buffer[3] = power;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 47, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int RfOutput(byte ComAddr, byte OnOff) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 48;
        buffer[3] = OnOff;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 48, 1000);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetPowerMode(byte ComAddr, byte OnOff) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 107;
        buffer[3] = OnOff;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 107, 1000);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetAddress(byte ComAddr, byte newAddr) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 36;
        buffer[3] = newAddr;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 36, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetRegion(byte ComAddr, int band, int maxfre, int minfre) {
        byte[] buffer = new byte[7];
        buffer[0] = 6;
        buffer[1] = ComAddr;
        buffer[2] = 34;
        buffer[3] = (byte)((band & 0xC) << 4 | maxfre & 0x3F);
        buffer[4] = (byte)((band & 3) << 6 | minfre & 0x3F);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 34, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetAntennaMultiplexing(byte ComAddr, byte SetOnce, byte AntCfg1, byte AntCfg2) {
        byte[] buffer = new byte[8];
        buffer[0] = 7;
        buffer[1] = ComAddr;
        buffer[2] = 63;
        buffer[3] = SetOnce;
        buffer[4] = AntCfg1;
        buffer[5] = AntCfg2;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 63, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int ConfigDRM(byte ComAddr, byte[] DRM) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = -112;
        buffer[3] = DRM[0];
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 144, 400);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                DRM[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetBeepNotification(byte ComAddr, byte BeepEn) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 64;
        buffer[3] = BeepEn;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 64, 400);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int ReadData_G2(byte ComAddr, byte ENum, byte[] EPC, byte Mem, byte WordPtr, byte Num, byte[] Password, byte MaskMem, byte[] MaskAdr, byte MaskLen, byte[] MaskData, byte MaskFlag, byte[] Data, byte[] Errorcode) {
        if (MaskFlag == 0) {
            byte[] buffer = new byte[13 + ENum * 2];
            buffer[0] = (byte)(12 + ENum * 2);
            buffer[1] = ComAddr;
            buffer[2] = 2;
            buffer[3] = ENum;
            System.arraycopy(EPC, 0, buffer, 4, ENum * 2);
            Log.e((String)TAG, (String)("ReadData_G2 Mem --> " + Mem));
            Log.e((String)TAG, (String)("ReadData_G2 WordPtr --> " + WordPtr));
            Log.e((String)TAG, (String)("ReadData_G2 Num --> " + Num));
            buffer[ENum * 2 + 4] = Mem;
            buffer[ENum * 2 + 5] = WordPtr;
            buffer[ENum * 2 + 6] = Num;
            System.arraycopy(Password, 0, buffer, ENum * 2 + 7, 4);
            this.getCRC(buffer, buffer[0] - 1);
            this.SendCMD(buffer);
            int result = this.GetCMDData(this.recvBuff, this.recvLength, 2, 3000);
            if (result == 0) {
                if (this.recvBuff[3] == 0) {
                    Errorcode[0] = 0;
                    System.arraycopy(this.recvBuff, 4, Data, 0, Num * 2);
                } else if ((this.recvBuff[3] & 0xFF) == 252) {
                    Errorcode[0] = this.recvBuff[4];
                }
                return this.recvBuff[3] & 0xFF;
            }
            return 48;
        }
        Log.e((String)TAG, (String)("ReadData_G2 recvBuff 1--> " + this.bytesToHexString(this.recvBuff, 0, this.recvBuff.length)));
        if (MaskLen == 0) {
            return 255;
        }
        int maskbyte = 0;
        int mLen = MaskLen & 0xFF;
        maskbyte = mLen % 8 == 0 ? mLen / 8 : mLen / 8 + 1;
        byte[] buffer = new byte[17 + maskbyte];
        Log.e((String)TAG, (String)("ReadData_G2 MaskLen --> " + MaskLen));
        Log.e((String)TAG, (String)("ReadData_G2 mLen --> " + mLen));
        Log.e((String)TAG, (String)("ReadData_G2 maskbyte --> " + maskbyte));
        Log.e((String)TAG, (String)("ReadData_G2 buffer --> " + buffer));
        buffer[0] = (byte)(16 + maskbyte);
        buffer[1] = ComAddr;
        buffer[2] = 2;
        buffer[3] = ENum;
        if ((ENum & 0xFF) == 255) {
            ENum = 0;
        }
        System.arraycopy(EPC, 0, buffer, 4, ENum * 2);
        Log.e((String)TAG, (String)("ReadData_G2 Mem --> " + Mem));
        Log.e((String)TAG, (String)("ReadData_G2 WordPtr --> " + WordPtr));
        Log.e((String)TAG, (String)("ReadData_G2 Num --> " + Num));
        buffer[ENum * 2 + 4] = Mem;
        buffer[ENum * 2 + 5] = WordPtr;
        buffer[ENum * 2 + 6] = Num;
        System.arraycopy(Password, 0, buffer, ENum * 2 + 7, 4);
        Log.e((String)TAG, (String)("ReadData_G2: MaskAdr[1] -->" + MaskAdr[1]));
        buffer[ENum * 2 + 11] = MaskMem;
        buffer[ENum * 2 + 12] = MaskAdr[0];
        buffer[ENum * 2 + 13] = MaskAdr[1];
        buffer[ENum * 2 + 14] = MaskLen;
        System.arraycopy(MaskData, 0, buffer, ENum * 2 + 15, maskbyte);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 2, 3000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
                Log.e((String)TAG, (String)("ReadData_G2 recvBuff 2--> " + this.bytesToHexString(this.recvBuff, 0, this.recvBuff.length)));
                System.arraycopy(this.recvBuff, 4, Data, 0, Num * 2);
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int ExtReadData_G2(byte ComAddr, byte ENum, byte[] EPC, byte Mem, byte[] WordPtr, byte Num, byte[] Password, byte MaskMem, byte[] MaskAdr, byte MaskLen, byte[] MaskData, byte MaskFlag, byte[] Data, byte[] Errorcode) {
        if (MaskFlag == 0) {
            byte[] buffer = new byte[14 + ENum * 2];
            buffer[0] = (byte)(13 + ENum * 2);
            buffer[1] = ComAddr;
            buffer[2] = 21;
            buffer[3] = ENum;
            if ((ENum & 0xFF) > 0) {
                System.arraycopy(EPC, 0, buffer, 4, ENum * 2);
            }
            buffer[ENum * 2 + 4] = Mem;
            buffer[ENum * 2 + 5] = WordPtr[0];
            buffer[ENum * 2 + 6] = WordPtr[1];
            buffer[ENum * 2 + 7] = Num;
            System.arraycopy(Password, 0, buffer, ENum * 2 + 8, 4);
            this.getCRC(buffer, (buffer[0] & 0xFF) - 1);
            this.SendCMD(buffer);
            int result = this.GetCMDData(this.recvBuff, this.recvLength, 21, 3000);
            if (result == 0) {
                if (this.recvBuff[3] == 0) {
                    Errorcode[0] = 0;
                    System.arraycopy(this.recvBuff, 4, Data, 0, Num * 2);
                } else if ((this.recvBuff[3] & 0xFF) == 252) {
                    Errorcode[0] = this.recvBuff[4];
                }
                return this.recvBuff[3] & 0xFF;
            }
            return 48;
        }
        if (MaskLen == 0) {
            return 255;
        }
        int maskbyte = 0;
        int mLen = MaskLen & 0xFF;
        maskbyte = mLen % 8 == 0 ? mLen / 8 : mLen / 8 + 1;
        byte[] buffer = new byte[18 + maskbyte];
        buffer[0] = (byte)(17 + maskbyte);
        buffer[1] = ComAddr;
        buffer[2] = 21;
        buffer[3] = ENum;
        buffer[4] = Mem;
        buffer[5] = WordPtr[0];
        buffer[6] = WordPtr[1];
        buffer[7] = Num;
        System.arraycopy(Password, 0, buffer, 8, 4);
        buffer[12] = MaskMem;
        buffer[13] = MaskAdr[0];
        buffer[14] = MaskAdr[1];
        buffer[15] = MaskLen;
        System.arraycopy(MaskData, 0, buffer, 16, maskbyte);
        this.getCRC(buffer, (buffer[0] & 0xFF) - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 21, 3000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
                System.arraycopy(this.recvBuff, 4, Data, 0, Num * 2);
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int WriteData_G2(byte ComAddr, byte WNum, byte ENum, byte[] EPC, byte Mem, byte WordPtr, byte[] Writedata, byte[] Password, byte MaskMem, byte[] MaskAdr, byte MaskLen, byte[] MaskData, byte MaskFlag, byte[] Errorcode) {
        if (MaskFlag == 0) {
            Log.e((String)TAG, (String)("WriteData_G2 ENum -->" + ENum));
            Log.e((String)TAG, (String)("WriteData_G2 WNum -->" + WNum));
            Log.e((String)TAG, (String)("WriteData_G2 Mem --> " + Mem));
            Log.e((String)TAG, (String)("WriteData_G2 WordPtr -->" + WordPtr));
            Log.e((String)TAG, (String)("WriteData_G2 ComAddr --> " + ComAddr));
            byte[] buffer = new byte[13 + (ENum + WNum) * 2];
            buffer[0] = (byte)(12 + (ENum + WNum) * 2);
            buffer[1] = ComAddr;
            buffer[2] = 3;
            buffer[3] = WNum;
            buffer[4] = ENum;
            System.arraycopy(EPC, 0, buffer, 5, ENum * 2);
            buffer[ENum * 2 + 5] = Mem;
            buffer[ENum * 2 + 6] = WordPtr;
            System.arraycopy(Writedata, 0, buffer, ENum * 2 + 7, WNum * 2);
            System.arraycopy(Password, 0, buffer, ENum * 2 + WNum * 2 + 7, 4);
            this.getCRC(buffer, buffer[0] - 1);
            this.SendCMD(buffer);
            int result = this.GetCMDData(this.recvBuff, this.recvLength, 3, 3000);
            if (result == 0) {
                if (this.recvBuff[3] == 0) {
                    Errorcode[0] = 0;
                } else if ((this.recvBuff[3] & 0xFF) == 252) {
                    Errorcode[0] = this.recvBuff[4];
                }
                return this.recvBuff[3] & 0xFF;
            }
            return 48;
        }
        Log.e((String)TAG, (String)("WriteData_G2 ENum -->" + ENum));
        Log.e((String)TAG, (String)("WriteData_G2 WNum -->" + WNum));
        Log.e((String)TAG, (String)("WriteData_G2 Mem --> " + Mem));
        Log.e((String)TAG, (String)("WriteData_G2 WordPtr -->" + WordPtr));
        Log.e((String)TAG, (String)("WriteData_G2 ComAddr --> " + ComAddr));
        if (MaskLen == 0) {
            return 255;
        }
        int maskbyte = 0;
        int mLen = MaskLen & 0xFF;
        Log.e((String)TAG, (String)("WriteData_G2: mLen --> " + mLen));
        maskbyte = mLen % 8 == 0 ? mLen / 8 : mLen / 8 + 1;
        Log.e((String)TAG, (String)("WriteData_G2 maskbyte --> " + maskbyte));
        byte[] buffer = new byte[17 + WNum * 2 + maskbyte];
        buffer[0] = (byte)(16 + WNum * 2 + maskbyte);
        buffer[1] = ComAddr;
        buffer[2] = 3;
        buffer[3] = WNum;
        buffer[4] = ENum;
        if ((ENum & 0xFF) == 255) {
            ENum = 0;
        }
        System.arraycopy(EPC, 0, buffer, 5, ENum * 2);
        buffer[ENum * 2 + 5] = Mem;
        buffer[ENum * 2 + 6] = WordPtr;
        System.arraycopy(Writedata, 0, buffer, ENum * 2 + 7, WNum * 2);
        System.arraycopy(Password, 0, buffer, ENum * 2 + WNum * 2 + 7, 4);
        buffer[ENum * 2 + WNum * 2 + 11] = MaskMem;
        buffer[ENum * 2 + WNum * 2 + 12] = MaskAdr[0];
        buffer[ENum * 2 + WNum * 2 + 13] = MaskAdr[1];
        buffer[ENum * 2 + WNum * 2 + 14] = MaskLen;
        Log.e((String)TAG, (String)("WriteData_G2: MaskData's length -->" + MaskData.length));
        System.arraycopy(MaskData, 0, buffer, ENum * 2 + WNum * 2 + 15, maskbyte);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 3, 3000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int ExtWriteData_G2(byte ComAddr, byte WNum, byte ENum, byte[] EPC, byte Mem, byte[] WordPtr, byte[] Writedata, byte[] Password, byte[] Errorcode) {
        byte[] buffer = new byte[14 + (ENum + WNum) * 2];
        buffer[0] = (byte)(13 + (ENum + WNum) * 2);
        buffer[1] = ComAddr;
        buffer[2] = 22;
        buffer[3] = WNum;
        buffer[4] = ENum;
        if ((ENum & 0xFF) == 255) {
            ENum = 0;
        }
        System.arraycopy(EPC, 0, buffer, 5, ENum * 2);
        buffer[ENum * 2 + 5] = Mem;
        buffer[ENum * 2 + 6] = WordPtr[0];
        buffer[ENum * 2 + 7] = WordPtr[1];
        System.arraycopy(Writedata, 0, buffer, ENum * 2 + 8, WNum * 2);
        System.arraycopy(Password, 0, buffer, ENum * 2 + WNum * 2 + 9, 4);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 22, 3000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int WriteEPC_G2(byte ComAddr, byte ENum, byte[] Password, byte[] WriteEPC, byte[] Errorcode) {
        byte[] buffer = new byte[10 + ENum * 2];
        buffer[0] = (byte)(9 + ENum * 2);
        buffer[1] = ComAddr;
        buffer[2] = 4;
        buffer[3] = ENum;
        System.arraycopy(Password, 0, buffer, 4, 4);
        System.arraycopy(WriteEPC, 0, buffer, 8, ENum * 2);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 4, 2000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int Lock_G2(byte ComAddr, byte ENum, byte[] EPC, byte select, byte setprotect, byte[] Password, byte[] Errorcode) {
        byte[] buffer = new byte[12 + ENum * 2];
        buffer[0] = (byte)(11 + ENum * 2);
        buffer[1] = ComAddr;
        buffer[2] = 6;
        buffer[3] = ENum;
        System.arraycopy(EPC, 0, buffer, 4, ENum * 2);
        buffer[ENum * 2 + 4] = select;
        buffer[ENum * 2 + 5] = setprotect;
        System.arraycopy(Password, 0, buffer, ENum * 2 + 6, 4);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 6, 1000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int Kill_G2(byte ComAddr, byte ENum, byte[] EPC, byte[] Password, byte[] Errorcode) {
        byte[] buffer = new byte[10 + ENum * 2];
        buffer[0] = (byte)(11 + ENum * 2);
        buffer[1] = ComAddr;
        buffer[2] = 5;
        buffer[3] = ENum;
        System.arraycopy(EPC, 0, buffer, 4, ENum * 2);
        System.arraycopy(Password, 0, buffer, ENum * 2 + 4, 4);
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 6, 1000);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Errorcode[0] = 0;
            } else if ((this.recvBuff[3] & 0xFF) == 252) {
                Errorcode[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int MeasureReturnLoss(byte ComAddr, byte[] TestFreq, byte Ant, byte[] ReturnLoss) {
        byte[] buffer = new byte[10];
        buffer[0] = 9;
        buffer[1] = ComAddr;
        buffer[2] = -111;
        System.arraycopy(TestFreq, 0, buffer, 3, 4);
        buffer[7] = Ant;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 145, 600);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                ReturnLoss[0] = this.recvBuff[4];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int MeasureTemperature(byte ComAddr, byte[] Temp) {
        byte[] buffer = new byte[5];
        buffer[0] = 4;
        buffer[1] = ComAddr;
        buffer[2] = -110;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 146, 600);
        if (result == 0) {
            if (this.recvBuff[3] == 0) {
                Temp[0] = this.recvBuff[4];
                Temp[1] = this.recvBuff[5];
            }
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetCheckAnt(byte ComAddr, byte CheckAnt) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 102;
        buffer[3] = CheckAnt;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 102, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetReadParameter(byte ComAddr, byte[] Parameter) {
        byte[] buffer = new byte[10];
        buffer[0] = 9;
        buffer[1] = ComAddr;
        buffer[2] = 117;
        buffer[3] = Parameter[0];
        buffer[4] = Parameter[1];
        buffer[5] = Parameter[2];
        buffer[6] = Parameter[3];
        buffer[7] = Parameter[4];
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 117, 500);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int GetReadParameter(byte ComAddr, byte[] Parameter) {
        byte[] buffer = new byte[5];
        buffer[0] = 4;
        buffer[1] = ComAddr;
        buffer[2] = 119;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 119, 300);
        if (result == 0) {
            System.arraycopy(this.recvBuff, 4, Parameter, 0, 6);
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetWorkMode(byte ComAddr, byte ReadMode) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 118;
        buffer[3] = ReadMode;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 118, 1000);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }

    public int SetBaudRate(byte ComAddr, byte baud) {
        byte[] buffer = new byte[6];
        buffer[0] = 5;
        buffer[1] = ComAddr;
        buffer[2] = 40;
        buffer[3] = baud;
        this.getCRC(buffer, buffer[0] - 1);
        this.SendCMD(buffer);
        int result = this.GetCMDData(this.recvBuff, this.recvLength, 40, 1000);
        if (result == 0) {
            return this.recvBuff[3] & 0xFF;
        }
        return 48;
    }
}

