/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgAppSetReaderMac
extends Message {
    private String mac;

    public MsgAppSetReaderMac() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)19;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetReaderMac(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.mac = String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (!StringUtils.isNullOfEmpty(this.mac)) {
            String[] macs;
            for (String s : macs = this.mac.split("-")) {
                buffer.putInt(Integer.parseInt(s, 16), 8);
            }
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Reader MAC parameter error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

