/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.lcrrgxmodule.factory;

import android.bld.rfid.aidl.BaseInfo;
import android.bld.rfid.aidl.QueryInfo;
import android.bld.rfid.aidl.TagData;
import android.media.SoundPool;
import android.os.SystemClock;
import android.util.Log;
import com.rfid.InventoryTagMap;
import com.rfid.InventoryTagResult;
import com.rfid.trans.BaseReader;
import com.rfid.trans.ReadTag;
import com.rfid.trans.ReaderParameter;
import com.rfid.trans.TagCallback;
import com.uhf.lcrrgxmodule.factory.ILcUhfProduct;
import java.util.ArrayList;
import java.util.List;

public class RfidUhfProduct
implements ILcUhfProduct {
    private final String TAG = "bldAdd#" + RfidUhfProduct.class.getSimpleName();
    private static String devport = "/dev/ttyS3";
    private static String devport2 = "/dev/ttyS2";
    private BaseReader reader = new BaseReader();
    private ReaderParameter param = new ReaderParameter();
    private volatile boolean mWorking = true;
    private volatile Thread mThread = null;
    private volatile boolean soundworking = true;
    private volatile boolean isSound = false;
    private volatile Thread sThread = null;
    private byte[] pOUcharIDList = new byte[25600];
    private volatile int NoCardCOunt = 0;
    private Integer soundid = null;
    private SoundPool soundPool = null;
    private TagCallback callback;
    public String devName = "";
    private long beginTime;
    private long endtime;
    private long ttbegintime;
    private int CurrentNum = 0;
    public static List<InventoryTagMap> lsTagList = new ArrayList<InventoryTagMap>();
    public static List<InventoryTagResult> lsList = new ArrayList<InventoryTagResult>();

    public RfidUhfProduct() {
        this.param.ComAddr = (byte)-1;
        this.param.ScanTime = 20;
        this.param.Session = 0;
        this.param.QValue = 4;
        this.param.TidLen = 0;
        this.param.TidPtr = 0;
        this.param.Antenna = 128;
        this.param.Interval = 20;
    }

    @Override
    public void beginSound(boolean sound) {
        this.isSound = sound;
    }

    @Override
    public void setsoundid(int id, SoundPool soundPool) {
        this.soundid = id;
        this.soundPool = soundPool;
    }

    @Override
    public void playSound() {
        if (this.soundid == null || this.soundPool == null) {
            return;
        }
        try {
            this.soundPool.play(this.soundid.intValue(), 1.0f, 1.0f, 1, 0, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int Connect() {
        String ComPort = devport;
        int BaudRate = 115200;
        int result = this.Connect(ComPort, BaudRate);
        if (result != 0) {
            result = this.Connect(ComPort, 57600);
        }
        if (result != 0) {
            result = this.Connect(devport2, BaudRate);
        }
        return result;
    }

    @Override
    public int Connect(String ComPort, int BaudRate) {
        int result = this.reader.Connect(ComPort, BaudRate, 1);
        if (result == 0) {
            SystemClock.sleep((long)100L);
            byte[] Version = new byte[2];
            byte[] Power = new byte[1];
            byte[] band = new byte[1];
            byte[] MaxFre = new byte[1];
            byte[] MinFre = new byte[1];
            byte[] BeepEn = new byte[1];
            byte[] Ant = new byte[1];
            result = this.GetUHFInformation(Version, Power, band, MaxFre, MinFre, BeepEn, Ant);
            if (result != 0) {
                this.reader.DisConnect();
            }
            this.devName = ComPort;
            this.isSound = false;
            this.soundworking = true;
            this.sThread = new Thread(() -> {
                while (this.soundworking) {
                    if (!this.isSound) continue;
                    this.playSound();
                    SystemClock.sleep((long)50L);
                }
            });
            this.sThread.start();
        }
        return result;
    }

    @Override
    public int DisConnect() {
        try {
            this.isSound = false;
            this.soundworking = false;
            this.sThread.interrupt();
            this.sThread = null;
            if (this.soundPool != null) {
                this.soundPool.release();
                this.soundPool = null;
            }
            if (lsTagList != null) {
                lsTagList.clear();
            }
            if (lsList != null) {
                lsList.clear();
            }
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)("DisConnect Exception=" + (ex != null ? ex.getMessage() : "error message is null!")));
        }
        return this.reader.DisConnect();
    }

    @Override
    public void SetInventoryParameter(ReaderParameter param) {
        this.param = param;
    }

    @Override
    public ReaderParameter GetInventoryParameter() {
        return this.param;
    }

    @Override
    public int GetUHFInformation(byte[] Version, byte[] Power, byte[] band, byte[] MaxFre, byte[] MinFre, byte[] BeepEn, byte[] Ant) {
        byte[] ReaderType = new byte[1];
        byte[] TrType = new byte[1];
        byte[] ScanTime = new byte[1];
        byte[] OutputRep = new byte[1];
        byte[] CheckAnt = new byte[1];
        byte[] ComAddr = new byte[]{-1};
        int result = this.reader.GetReaderInformation(ComAddr, Version, ReaderType, TrType, band, MaxFre, MinFre, Power, ScanTime, Ant, BeepEn, OutputRep, CheckAnt);
        if (result == 0) {
            this.param.ComAddr = ComAddr[0];
            this.param.Antenna = Ant[0];
        }
        return result;
    }

    @Override
    public int SetRfPower(int Power) {
        return this.reader.SetRfPower(this.param.ComAddr, (byte)Power);
    }

    @Override
    public int SetRegion(int band, int maxfre, int minfre) {
        return this.reader.SetRegion(this.param.ComAddr, band, maxfre, minfre);
    }

    @Override
    public int RfOutput(byte OnOff) {
        return this.reader.RfOutput(this.param.ComAddr, OnOff);
    }

    @Override
    public int SetPowerMode(int OnOff) {
        return this.reader.SetPowerMode(this.param.ComAddr, (byte)(OnOff |= 0x80));
    }

    @Override
    public int MeasureTemperature(byte[] Temp) {
        return this.reader.MeasureTemperature(this.param.ComAddr, Temp);
    }

    @Override
    public int MeasureReturnLoss(byte[] ReturnLoss) {
        byte[] TestFreq = new byte[]{0, 13, -9, 50};
        byte Ant = 0;
        return this.reader.MeasureReturnLoss(this.param.ComAddr, TestFreq, Ant, ReturnLoss);
    }

    @Override
    public int SetAntenna(byte AntCfg) {
        byte SetOnce = 1;
        byte AntCfg1 = 0;
        int result = this.reader.SetAntennaMultiplexing(this.param.ComAddr, SetOnce, AntCfg1, AntCfg);
        if (result == 0) {
            this.param.Antenna = AntCfg;
        }
        return result;
    }

    @Override
    public int SetBeepNotification(int BeepEn) {
        return this.reader.SetBeepNotification(this.param.ComAddr, (byte)BeepEn);
    }

    @Override
    public int SetWorkMode(byte ReadMode) {
        return this.reader.SetWorkMode(this.param.ComAddr, ReadMode);
    }

    @Override
    public int SetBaudRate(byte BaudTate) {
        return this.reader.SetBaudRate(this.param.ComAddr, BaudTate);
    }

    @Override
    public int GetModuleVersion() {
        return 1;
    }

    @Override
    public void singleRead() {
    }

    @Override
    public void setBeepSuccess(int mode) {
    }

    @Override
    public void setTagDataList(List<TagData> tagDataList) {
    }

    @Override
    public List<TagData> getTagDataList() {
        return null;
    }

    @Override
    public List<TagData> getFilterTags() {
        return null;
    }

    @Override
    public void setQueryInfo(QueryInfo queryInfo) {
    }

    @Override
    public QueryInfo getQueryInfo() {
        return null;
    }

    @Override
    public BaseInfo getBaseInfo() {
        return null;
    }

    @Override
    public String ReadDataByEPC(String EPCStr, byte Mem, int WordPtr, byte Num, byte[] Password) {
        if (EPCStr.length() % 4 != 0) {
            return "FF";
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte MaskMem = 0;
        byte[] MaskAdr = new byte[2];
        byte MaskLen = 0;
        byte[] MaskData = new byte[12];
        byte MaskFlag = 0;
        byte[] Data = new byte[Num * 2];
        byte[] ErrorCode = new byte[1];
        byte[] WordPtr1 = new byte[]{(byte)(WordPtr >> 8 & 0xFF), (byte)(WordPtr & 0xFF)};
        int result = this.reader.ExtReadData_G2(this.param.ComAddr, ENum, EPC, Mem, WordPtr1, Num, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Data, ErrorCode);
        if (result == 0) {
            return this.reader.bytesToHexString(Data, 0, Data.length);
        }
        return String.format("%2X", result);
    }

    @Override
    public String ReadDataByTID(String TIDStr, byte Mem, int WordPtr, byte Num, byte[] Password) {
        if (TIDStr.length() % 4 != 0) {
            return "FF";
        }
        byte ENum = -1;
        byte[] EPC = new byte[12];
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        Log.e((String)this.TAG, (String)("hexStringToBytes 1: " + TIDStr));
        Log.e((String)this.TAG, (String)("bytesToHexString 2: " + this.reader.bytesToHexString(TID, 0, TID.length)));
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] Data = new byte[Num * 2];
        byte[] Errorcode = new byte[1];
        byte[] WordPtr1 = new byte[]{(byte)(WordPtr >> 8 & 0xFF), (byte)(WordPtr & 0xFF)};
        int result = this.reader.ExtReadData_G2(this.param.ComAddr, ENum, EPC, Mem, WordPtr1, Num, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, Data, Errorcode);
        if (result == 0) {
            return this.reader.bytesToHexString(Data, 0, Data.length);
        }
        return String.format("%2X", result);
    }

    @Override
    public int WriteDataByEPC(String EPCStr, byte Mem, int WordPtr, byte[] Password, String wdata) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (wdata.length() % 4 != 0) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte WNum = (byte)(wdata.length() / 4);
        Log.e((String)this.TAG, (String)("WriteDataByEPC: ENUM -->" + ENum));
        Log.e((String)this.TAG, (String)("WriteDataByEPC: EPCStr -->" + EPCStr));
        Log.e((String)this.TAG, (String)("WriteDataByEPC: wdata -->" + wdata));
        String PCStr = "";
        switch (WNum) {
            case 1: {
                PCStr = "0800";
                break;
            }
            case 2: {
                PCStr = "1000";
                break;
            }
            case 3: {
                PCStr = "1800";
                break;
            }
            case 4: {
                PCStr = "2000";
                break;
            }
            case 5: {
                PCStr = "2800";
                break;
            }
            case 6: {
                PCStr = "3000";
                break;
            }
            case 7: {
                PCStr = "3800";
                break;
            }
            case 8: {
                PCStr = "4000";
                break;
            }
            case 9: {
                PCStr = "4800";
                break;
            }
            case 10: {
                PCStr = "5000";
                break;
            }
            case 11: {
                PCStr = "5800";
                break;
            }
            case 12: {
                PCStr = "6000";
                break;
            }
            case 13: {
                PCStr = "6800";
                break;
            }
            case 14: {
                PCStr = "7000";
                break;
            }
            case 15: {
                PCStr = "7800";
                break;
            }
            case 16: {
                PCStr = "8000";
            }
        }
        wdata = PCStr + wdata;
        Log.e((String)this.TAG, (String)("WriteDataByEPC: wdata2 -->" + wdata));
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte fullDataWordCount = (byte)(wdata.length() / 4);
        boolean MaskMem = false;
        byte[] MaskAdr = new byte[2];
        boolean MaskLen = false;
        byte[] MaskData = new byte[12];
        boolean MaskFlag = false;
        byte[] ErrorCode = new byte[1];
        byte[] WordPtr1 = new byte[]{(byte)(WordPtr >> 8 & 0xFF), (byte)(WordPtr & 0xFF)};
        Log.e((String)this.TAG, (String)("WriteDataByEPC WordPtr1[0] --> " + WordPtr1[0]));
        Log.e((String)this.TAG, (String)("WriteDataByEPC WordPtr1[1] --> " + WordPtr1[1]));
        return this.reader.ExtWriteData_G2(this.param.ComAddr, fullDataWordCount, ENum, EPC, Mem, WordPtr1, data, Password, ErrorCode);
    }

    @Override
    public int WriteDataByTID(String TIDStr, byte Mem, byte WordPtr, byte[] Password, String wdata) {
        if (TIDStr.length() % 4 != 0) {
            return 255;
        }
        if (wdata.length() % 4 != 0) {
            return 255;
        }
        byte ENum = -1;
        byte WNum = (byte)(wdata.length() / 4);
        byte[] EPC = new byte[12];
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] ErrorCode = new byte[1];
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, ErrorCode);
    }

    @Override
    public int WriteEPCByTID(String TIDStr, String EPCStr, byte[] Password) {
        if (TIDStr.length() % 4 != 0) {
            return 255;
        }
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        byte ENum = -1;
        byte WNum = (byte)(EPCStr.length() / 4);
        byte[] EPC = new byte[12];
        String PCStr = "";
        switch (WNum) {
            case 1: {
                PCStr = "";
                break;
            }
            case 2: {
                PCStr = "";
                break;
            }
            case 3: {
                PCStr = "";
                break;
            }
            case 4: {
                PCStr = "";
                break;
            }
            case 5: {
                PCStr = "";
                break;
            }
            case 6: {
                PCStr = "";
                break;
            }
            case 7: {
                PCStr = "";
                break;
            }
            case 8: {
                PCStr = "";
                break;
            }
            case 9: {
                PCStr = "";
                break;
            }
            case 10: {
                PCStr = "";
                break;
            }
            case 11: {
                PCStr = "";
                break;
            }
            case 12: {
                PCStr = "";
                break;
            }
            case 13: {
                PCStr = "";
                break;
            }
            case 14: {
                PCStr = "";
                break;
            }
            case 15: {
                PCStr = "";
                break;
            }
            case 16: {
                PCStr = "";
            }
        }
        String wdata = PCStr + EPCStr;
        byte[] data = this.reader.hexStringToBytes(wdata);
        byte[] TID = this.reader.hexStringToBytes(TIDStr);
        byte MaskMem = 2;
        byte[] MaskAdr = new byte[2];
        MaskAdr[1] = 0;
        MaskAdr[0] = 0;
        byte MaskLen = (byte)(TIDStr.length() * 4);
        byte[] MaskData = new byte[TIDStr.length()];
        System.arraycopy(TID, 0, MaskData, 0, TID.length);
        byte MaskFlag = 1;
        byte[] ErrorCode = new byte[1];
        byte Mem = 1;
        byte WordPtr = 1;
        Log.e((String)this.TAG, (String)("WriteEPCByTID wdata -->" + wdata));
        Log.e((String)this.TAG, (String)("WriteEPCByTID WNum --> " + WNum));
        Log.e((String)this.TAG, (String)("WriteEPCByTID ENum --> " + ENum));
        Log.e((String)this.TAG, (String)("WriteEPCByTID EPC --> " + EPC));
        Log.e((String)this.TAG, (String)("WriteEPCByTID Mem --> " + Mem));
        Log.e((String)this.TAG, (String)("WriteEPCByTID WordPtr --> " + WordPtr));
        Log.e((String)this.TAG, (String)("WriteEPCByTID data --> " + data));
        return this.reader.WriteData_G2(this.param.ComAddr, WNum, ENum, EPC, Mem, WordPtr, data, Password, MaskMem, MaskAdr, MaskLen, MaskData, MaskFlag, ErrorCode);
    }

    @Override
    public int Lock(String EPCStr, byte select, byte setprotect, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] ErrorCode = new byte[1];
        return this.reader.Lock_G2(this.param.ComAddr, ENum, EPC, select, setprotect, Password, ErrorCode);
    }

    @Override
    public int Kill(String EPCStr, String PasswordStr) {
        if (EPCStr.length() % 4 != 0) {
            return 255;
        }
        if (PasswordStr.length() != 8) {
            return 255;
        }
        byte ENum = (byte)(EPCStr.length() / 4);
        byte[] EPC = this.reader.hexStringToBytes(EPCStr);
        byte[] Password = this.reader.hexStringToBytes(PasswordStr);
        byte[] ErrorCode = new byte[1];
        return this.reader.Kill_G2(this.param.ComAddr, ENum, EPC, Password, ErrorCode);
    }

    @Override
    public void SetCallBack(TagCallback callback) {
        this.callback = callback;
        this.reader.SetCallBack(callback);
    }

    @Override
    public int StartRead() {
        if (this.mThread == null) {
            this.mWorking = true;
            this.mThread = new Thread(() -> {
                byte Target = 0;
                this.CurrentNum = 0;
                this.ttbegintime = SystemClock.elapsedRealtime();
                while (this.mWorking) {
                    byte Ant = -128;
                    int[] pOUcharTagNum = new int[1];
                    int[] pListLen = new int[]{0};
                    pOUcharTagNum[0] = 0;
                    if (this.param.Session == 0 || this.param.Session == 1) {
                        Target = 0;
                        this.NoCardCOunt = 0;
                    }
                    this.beginTime = SystemClock.elapsedRealtime();
                    pOUcharTagNum[0] = 0;
                    int result = this.reader.Inventory_G2(this.param.ComAddr, (byte)this.param.QValue, (byte)this.param.Session, (byte)this.param.TidPtr, (byte)this.param.TidLen, Target, Ant, this.param.ScanTime, this.pOUcharIDList, pOUcharTagNum, pListLen);
                    if (pOUcharTagNum[0] == 0) {
                        this.isSound = false;
                        if (this.param.Session > 1) {
                            ++this.NoCardCOunt;
                            if (this.NoCardCOunt > 7) {
                                Target = (byte)(1 - Target);
                                this.NoCardCOunt = 0;
                            }
                        }
                    } else {
                        this.NoCardCOunt = 0;
                        this.isSound = true;
                    }
                    this.endtime = SystemClock.elapsedRealtime();
                    InventoryTagResult mtag = new InventoryTagResult();
                    mtag.nCount = pOUcharTagNum[0];
                    mtag.nTime = this.endtime - this.beginTime;
                    mtag.speed = (int)((long)(mtag.nCount * 1000) / mtag.nTime);
                    mtag.result = result;
                    mtag.NewNum = lsTagList.size() - this.CurrentNum;
                    this.CurrentNum = lsTagList.size();
                    mtag.TotalTime = SystemClock.elapsedRealtime() - this.ttbegintime;
                    lsList.add(mtag);
                    SystemClock.sleep((long)this.param.Interval);
                }
                this.isSound = false;
                this.mThread = null;
                if (this.callback != null) {
                    this.callback.FinishCallBack();
                }
            });
            this.mThread.start();
            return 0;
        }
        return 1;
    }

    @Override
    public void StopRead() {
        this.mWorking = false;
        if (this.mThread != null) {
            this.isSound = false;
        }
    }

    @Override
    public List<InventoryTagMap> getInventoryTagMapList() {
        return lsTagList;
    }

    @Override
    public List<InventoryTagResult> getInventoryTagResultList() {
        return lsList;
    }

    public class OutDataCB
    implements TagCallback {
        @Override
        public void tagCallback(ReadTag arg0) {
            String epc = arg0.epcId.toUpperCase();
        }

        @Override
        public int CRCErrorCallBack(int reason) {
            return 0;
        }

        @Override
        public void FinishCallBack() {
        }

        @Override
        public int tagCallbackFailed(int reason) {
            return 0;
        }
    }
}

