/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetResidenceTime
extends Message {
    private Long antResidenceTime;
    private Long frqResidenceTime;

    public MsgBaseGetResidenceTime() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-31;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetResidenceTime(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.antResidenceTime = buffer.getLongUnsigned(16);
                        break;
                    }
                    case 2: {
                        this.frqResidenceTime = buffer.getLongUnsigned(16);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntResidenceTime() {
        return this.antResidenceTime;
    }

    public void setAntResidenceTime(Long antResidenceTime) {
        this.antResidenceTime = antResidenceTime;
    }

    public Long getFrqResidenceTime() {
        return this.frqResidenceTime;
    }

    public void setFrqResidenceTime(Long frqResidenceTime) {
        this.frqResidenceTime = frqResidenceTime;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.put(1, 8);
            buffer.putLong(this.antResidenceTime, 16);
            buffer.put(2, 8);
            buffer.putLong(this.frqResidenceTime, 16);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            while (buffer.position() / 8 < this.cData.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        this.antResidenceTime = buffer.getLongUnsigned(16);
                        break;
                    }
                    case 2: {
                        this.frqResidenceTime = buffer.getLongUnsigned(16);
                    }
                }
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetResidenceTime{antResidenceTime=" + this.antResidenceTime + ", frqResidenceTime=" + this.frqResidenceTime + '}';
    }
}

