/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseSetPower
extends Message {
    private Hashtable<Integer, Integer> dicPower;
    private int powerDownSave = Integer.MAX_VALUE;

    public MsgBaseSetPower() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = 1;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetPower(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            for (int i = 0; i < data.length / 2; ++i) {
                int key = buffer.getIntUnsigned(8);
                if (key == 255) {
                    this.powerDownSave = buffer.getIntUnsigned(8);
                    continue;
                }
                int value = buffer.getIntUnsigned(8);
                if (null == this.dicPower) {
                    this.dicPower = new Hashtable();
                }
                this.dicPower.put(key, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Hashtable<Integer, Integer> getDicPower() {
        return this.dicPower;
    }

    public void setDicPower(Hashtable<Integer, Integer> dicPower) {
        this.dicPower = dicPower;
    }

    public int getPowerDownSave() {
        return this.powerDownSave;
    }

    public void setPowerDownSave(int powerDownSave) {
        this.powerDownSave = powerDownSave;
    }

    @Override
    public void pack() {
        if (null != this.dicPower && this.dicPower.size() > 0) {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            for (int iKey : this.dicPower.keySet()) {
                buffer.putLong(iKey, 8);
                buffer.putLong(this.dicPower.get(iKey).intValue(), 8);
            }
            if (Integer.MAX_VALUE != this.powerDownSave) {
                buffer.putInt(255, 8);
                buffer.putInt(this.powerDownSave, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter not supported.");
                this.put((byte)2, "Power parameter not supported.");
                this.put((byte)3, "Save failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

