/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.dal.HandlerGClientConnected;
import com.gg.reader.api.dal.HandlerRemoteConnected;
import com.gg.reader.api.dal.communication.TcpClient;
import com.gg.reader.api.dal.communication.TcpServer;
import com.gg.reader.api.protocol.gx.MsgAppGetReaderInfo;
import java.util.HashMap;
import java.util.Map;

public class GServer {
    private TcpServer ts;
    private int MSG_TIME_OUT = 3000;
    public HandlerGClientConnected onGClientConnected;
    private HashMap<String, GClient> hpClient = new HashMap();

    public boolean isListend() {
        if (null == this.ts) {
            return false;
        }
        return this.ts.keepListen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGClientConnectedEvent(GClient client, String serialNumber) {
        block5: {
            try {
                if (this.onGClientConnected == null) break block5;
                HandlerGClientConnected handlerGClientConnected = this.onGClientConnected;
                synchronized (handlerGClientConnected) {
                    this.onGClientConnected.log(client, serialNumber);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean open(int param) {
        if (null != this.ts) {
            return false;
        }
        this.ts = new TcpServer();
        this.ts.onRemoteConnected = new HandlerRemoteConnected(){

            @Override
            public void log(TcpClient client) {
                GServer.this.processConnect(client);
            }
        };
        if (!this.ts.open(param)) {
            this.close();
            return false;
        }
        return true;
    }

    public void close() {
        if (null != this.ts) {
            this.ts.close();
            this.ts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClient(String readerName) {
        if (readerName == null || readerName == "") {
            return;
        }
        String[] arrName = readerName.split(":");
        if (null != arrName && arrName.length == 2) {
            HashMap<String, GClient> hashMap = this.hpClient;
            synchronized (hashMap) {
                if (this.hpClient.containsKey(readerName)) {
                    this.hpClient.get(readerName).close();
                    this.hpClient.remove(readerName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllClient() {
        HashMap<String, GClient> hashMap = this.hpClient;
        synchronized (hashMap) {
            for (Map.Entry<String, GClient> item : this.hpClient.entrySet()) {
                item.getValue().close();
            }
            this.hpClient.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConnect(TcpClient client) {
        if (null == client) {
            return;
        }
        GClient gClient = new GClient();
        String readerName = client.serverIp + ":" + client.serverPort;
        if (gClient.open(readerName, client, this.MSG_TIME_OUT)) {
            gClient.setName(readerName);
            MsgAppGetReaderInfo info = new MsgAppGetReaderInfo();
            gClient.sendSynMsg(info);
            String serialNumber = info.getRtCode() == 0 ? info.getReaderSerialNumber() : null;
            gClient.setSerialNumber(serialNumber);
            this.triggerGClientConnectedEvent(gClient, serialNumber);
            HashMap<String, GClient> hashMap = this.hpClient;
            synchronized (hashMap) {
                if (this.hpClient.containsKey(readerName)) {
                    this.hpClient.get(readerName).close();
                }
                this.hpClient.put(readerName, gClient);
            }
        } else {
            gClient.close();
            client.close();
        }
    }
}

