/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.OnUsbHidDeviceListener;
import com.gg.reader.api.dal.communication.OnUsbHidStateListener;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppGetBaseVersion;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidUsbHidClient
extends CommunicationInterface {
    private static final String ACTION_USB_PERMISSION = "com.android.gx.USB_PERMISSION";
    private UsbManager mUsbManager;
    private UsbDevice mUsbDevice;
    private UsbInterface mUsbInterface;
    private UsbDeviceConnection mConnection;
    public OnUsbHidDeviceListener deviceListener;
    public OnUsbHidStateListener stateListener;
    private UsbEndpoint mInUsbEndpoint;
    private UsbEndpoint mOutUsbEndpoint;
    private Handler mHandler;
    private int readTimeout = 1000;
    private int writeTimeout = 1000;
    private Context mContext;
    private String mUsbName;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (AndroidUsbHidClient.ACTION_USB_PERMISSION.equals(action)) {
                context.unregisterReceiver((BroadcastReceiver)this);
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false) && device != null) {
                        AndroidUsbHidClient.this.openDevice();
                    } else {
                        AndroidUsbHidClient.this.onConnectFailed();
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mUsbStateChange = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                if (AndroidUsbHidClient.this.stateListener != null) {
                    AndroidUsbHidClient.this.stateListener.onDeviceAttached();
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && AndroidUsbHidClient.this.stateListener != null) {
                AndroidUsbHidClient.this.stateListener.onDeviceDetached();
            }
        }
    };

    public static Map<String, AndroidUsbHidClient> enumerate(Context context, int vid, int pid) {
        UsbManager usbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (usbManager == null) {
            return null;
        }
        HashMap devices = usbManager.getDeviceList();
        HashMap<String, AndroidUsbHidClient> usbHidDevices = new HashMap<String, AndroidUsbHidClient>();
        for (String key : devices.keySet()) {
            UsbDevice device = (UsbDevice)devices.get(key);
            if (device == null || device.getVendorId() != vid || device.getProductId() != pid) continue;
            for (int i = 0; i < device.getInterfaceCount(); ++i) {
                UsbInterface usbInterface = device.getInterface(i);
                if (usbInterface.getInterfaceClass() != 3 || usbInterface.getInterfaceProtocol() != 0) continue;
                AndroidUsbHidClient hidDevice = new AndroidUsbHidClient(device, usbInterface, usbManager, context, key);
                usbHidDevices.put(key, hidDevice);
            }
        }
        return usbHidDevices;
    }

    public static Map<String, AndroidUsbHidClient> enumerate(Context context) {
        UsbManager usbManager = (UsbManager)context.getApplicationContext().getSystemService("usb");
        if (usbManager == null) {
            return null;
        }
        HashMap devices = usbManager.getDeviceList();
        HashMap<String, AndroidUsbHidClient> usbHidDevices = new HashMap<String, AndroidUsbHidClient>();
        for (String key : devices.keySet()) {
            UsbDevice device = (UsbDevice)devices.get(key);
            if (device == null || device.getVendorId() != 1003 || device.getProductId() != 9249) continue;
            for (int i = 0; i < device.getInterfaceCount(); ++i) {
                UsbInterface usbInterface = device.getInterface(i);
                if (usbInterface.getInterfaceClass() != 3 || usbInterface.getInterfaceProtocol() != 0) continue;
                AndroidUsbHidClient hidDevice = new AndroidUsbHidClient(device, usbInterface, usbManager, context, key);
                usbHidDevices.put(key, hidDevice);
            }
        }
        return usbHidDevices;
    }

    public static List<AndroidUsbHidClient> getUsbHidList(Context context) {
        Map<String, AndroidUsbHidClient> enumerate = AndroidUsbHidClient.enumerate(context);
        if (enumerate == null) {
            return null;
        }
        return new ArrayList<AndroidUsbHidClient>(enumerate.values());
    }

    public static List<AndroidUsbHidClient> getUsbHidList(Context context, int vid, int pid) {
        Map<String, AndroidUsbHidClient> enumerate = AndroidUsbHidClient.enumerate(context, vid, pid);
        if (enumerate == null) {
            return null;
        }
        return new ArrayList<AndroidUsbHidClient>(enumerate.values());
    }

    private AndroidUsbHidClient(UsbDevice usbDevice, UsbInterface usbInterface, UsbManager usbManager, Context context, String usbName) {
        this.mUsbDevice = usbDevice;
        this.mUsbInterface = usbInterface;
        this.mUsbManager = usbManager;
        this.mContext = context;
        this.mUsbName = usbName;
        for (int i = 0; i < this.mUsbInterface.getEndpointCount(); ++i) {
            UsbEndpoint endpoint = this.mUsbInterface.getEndpoint(i);
            int dir = endpoint.getDirection();
            int type = endpoint.getType();
            if (this.mInUsbEndpoint == null && dir == 128 && type == 3) {
                this.mInUsbEndpoint = endpoint;
            }
            if (this.mOutUsbEndpoint != null || dir != 0 || type != 3) continue;
            this.mOutUsbEndpoint = endpoint;
        }
    }

    public UsbDevice getUsbDevice() {
        return this.mUsbDevice;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public String getUsbName() {
        return this.mUsbName;
    }

    public void hasPermission() {
        this.mHandler = new Handler(this.mContext.getMainLooper());
        if (!this.mUsbManager.hasPermission(this.mUsbDevice)) {
            PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
            this.mContext.registerReceiver(this.mUsbReceiver, filter);
            this.mUsbManager.requestPermission(this.mUsbDevice, permissionIntent);
        } else {
            this.openDevice();
        }
    }

    private void openDevice() {
        this.mConnection = this.mUsbManager.openDevice(this.mUsbDevice);
        if (this.mConnection == null) {
            this.onConnectFailed();
            return;
        }
        if (!this.mConnection.claimInterface(this.mUsbInterface, true)) {
            this.onConnectFailed();
            return;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.mConnection.setInterface(this.mUsbInterface);
        }
        this.keepReceived = true;
        this.startReceive();
        this.startProcess();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AndroidUsbHidClient.this.deviceListener != null) {
                    AndroidUsbHidClient.this.send(new MsgAppGetBaseVersion());
                    AndroidUsbHidClient.this.send(new MsgAppGetBaseVersion());
                    AndroidUsbHidClient.this.deviceListener.onDeviceConnected(AndroidUsbHidClient.this);
                }
            }
        });
    }

    private void onConnectFailed() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (AndroidUsbHidClient.this.deviceListener != null) {
                    AndroidUsbHidClient.this.deviceListener.onDeviceConnectFailed(AndroidUsbHidClient.this);
                }
            }
        });
    }

    @Override
    public boolean open(String s, int i) {
        return false;
    }

    @Override
    public boolean open(Socket socket) {
        return false;
    }

    @Override
    public boolean open(String s, int i, int i1) {
        return false;
    }

    @Override
    public boolean open(String s) {
        this.hasPermission();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            if (this.mConnection != null) {
                if (this.mUsbInterface != null) {
                    this.mConnection.releaseInterface(this.mUsbInterface);
                }
                this.mConnection.close();
                this.mConnection = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
                this.ringBuffer.Clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        Class<AndroidUsbHidClient> clazz = AndroidUsbHidClient.class;
        synchronized (AndroidUsbHidClient.class) {
            try {
                int maxPacketSize = this.mOutUsbEndpoint.getMaxPacketSize();
                int pack = data.length / maxPacketSize;
                if (data.length % maxPacketSize > 0) {
                    ++pack;
                }
                for (int i = 0; i < pack; ++i) {
                    byte[] newBuffer = Arrays.copyOfRange(data, i * maxPacketSize, maxPacketSize + i * maxPacketSize);
                    this.mConnection.bulkTransfer(this.mOutUsbEndpoint, newBuffer, newBuffer.length, 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) {
        Class<AndroidUsbHidClient> clazz = AndroidUsbHidClient.class;
        synchronized (AndroidUsbHidClient.class) {
            try {
                if (this.isRs485) {
                    msg.msgType.mt_13 = "1";
                    msg.rs485Address = this.getRs485Address();
                }
                msg.pack();
                byte[] sendData = msg.toBytes(this.isRs485);
                this.send(sendData);
            }
            catch (Exception ex) {
                GLog.e("[AndroidUsbHidClient]send error:" + ex.getMessage());
            }
            return;
        }
    }

    @Override
    public int receive(byte[] bytes) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int i) {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (AndroidUsbHidClient.this.keepReceived) {
                    try {
                        byte[] buffer = new byte[AndroidUsbHidClient.this.mInUsbEndpoint.getMaxPacketSize()];
                        int bytesRead = AndroidUsbHidClient.this.mConnection.bulkTransfer(AndroidUsbHidClient.this.mInUsbEndpoint, buffer, buffer.length, AndroidUsbHidClient.this.readTimeout);
                        if (bytesRead <= 0) {
                            Thread.sleep(50L);
                            continue;
                        }
                        Object object = AndroidUsbHidClient.this.lockRingBuffer;
                        synchronized (object) {
                            while (bytesRead + AndroidUsbHidClient.this.ringBuffer.getDataCount() > 0x100000) {
                                AndroidUsbHidClient.this.lockRingBuffer.wait(10000L);
                            }
                            AndroidUsbHidClient.this.ringBuffer.WriteBuffer(buffer, 0, bytesRead);
                            AndroidUsbHidClient.this.lockRingBuffer.notify();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public void registerUsbState(Context context) {
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        IntentFilter usbFilter = new IntentFilter();
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
        usbFilter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        context.registerReceiver(this.mUsbStateChange, usbFilter);
    }

    public void unregisterState(Context context) {
        context.unregisterReceiver(this.mUsbStateChange);
    }
}

