/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.DateTimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.TimeZone;

public class MsgAppGetReaderTime
extends Message {
    private Date systemTime;

    public MsgAppGetReaderTime() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)17;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetReaderTime(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            long utcSecond = buffer.getLong(32) * 1000L;
            long utcMicrosecond = buffer.getLong(32) / 1000L;
            this.systemTime = DateTimeUtils.fromUtcToTimeZone(utcSecond + utcMicrosecond, TimeZone.getDefault());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date getSystemTime() {
        return this.systemTime;
    }

    public void setSystemTime(Date systemTime) {
        this.systemTime = systemTime;
    }

    public String getFormatTime() {
        return new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(this.getSystemTime());
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            String utc = new Formatter().format("%.3f", (double)DateTimeUtils.UtcFromTimeZone(this.systemTime, TimeZone.getDefault()) / 1000.0).toString();
            String[] split = utc.split("\\.");
            buffer.putLong(Integer.parseInt(split[0]), 32);
            buffer.putLong(Integer.parseInt(split[1]) * 1000, 32);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            long utcSecond = buffer.getLong(32) * 1000L;
            long utcMicrosecond = buffer.getLong(32) / 1000L;
            this.systemTime = DateTimeUtils.fromUtcToTimeZone(utcSecond + utcMicrosecond, TimeZone.getDefault());
            this.setRtCode((byte)0);
        }
    }
}

