/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgTestEnvRssiAutoDetection
extends Message {
    private Long antennaEnable;
    private int startFrequency;
    private int endFrequency;
    private int mode;

    public MsgTestEnvRssiAutoDetection() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)10;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestEnvRssiAutoDetection(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.startFrequency = buffer.getIntUnsigned(16);
            this.endFrequency = buffer.getIntUnsigned(16);
            this.mode = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getStartFrequency() {
        return this.startFrequency;
    }

    public void setStartFrequency(int startFrequency) {
        this.startFrequency = startFrequency;
    }

    public int getEndFrequency() {
        return this.endFrequency;
    }

    public void setEndFrequency(int endFrequency) {
        this.endFrequency = endFrequency;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        buffer.putInt(this.startFrequency, 16);
        buffer.putInt(this.endFrequency, 16);
        buffer.putInt(this.mode, 8);
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Start success.");
                this.put((byte)1, "FrequencyPoint Param Reader Not Support.");
                this.put((byte)2, "Port Param Reader Not Support.");
                this.put((byte)3, "Phase-locked loop locking failed");
                this.put((byte)4, "Other error");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

