/*
 * Decompiled with CFR 0.152.
 */
package me.weyye.hipermission;

import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;
import me.weyye.hipermission.PermissionItem;
import me.weyye.hipermission.R;

public class PermissionAdapter
extends BaseAdapter {
    private List<PermissionItem> mData;
    private int mTextColor;
    private int mFilterColor;

    public PermissionAdapter(List<PermissionItem> data) {
        this.mData = data;
    }

    public int getCount() {
        return this.mData.size();
    }

    public Object getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        PermissionItem item = this.mData.get(position);
        View view = View.inflate((Context)parent.getContext(), (int)R.layout.permission_info_item, null);
        int blue = Color.blue((int)this.mFilterColor);
        int green = Color.green((int)this.mFilterColor);
        int red = Color.red((int)this.mFilterColor);
        ImageView icon = (ImageView)view.findViewById(R.id.icon);
        float[] cm = new float[]{1.0f, 0.0f, 0.0f, 0.0f, red, 0.0f, 1.0f, 0.0f, 0.0f, green, 0.0f, 0.0f, 1.0f, 0.0f, blue, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f};
        ColorMatrixColorFilter filter = new ColorMatrixColorFilter(cm);
        icon.setColorFilter((ColorFilter)filter);
        TextView name = (TextView)view.findViewById(R.id.name);
        if (this.mTextColor != 0) {
            name.setTextColor(this.mTextColor);
        }
        icon.setImageResource(item.PermissionIconRes);
        name.setText((CharSequence)item.PermissionName);
        return view;
    }

    public void setTextColor(int itemTextColor) {
        this.mTextColor = itemTextColor;
        this.notifyDataSetChanged();
    }

    public void setFilterColor(int filterColor) {
        this.mFilterColor = filterColor;
        this.notifyDataSetChanged();
    }
}

