/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;

public class MsgAppGetReaderMac
extends Message {
    private String mac;

    public MsgAppGetReaderMac() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)6;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetReaderMac(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.mac = String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (!StringUtils.isNullOfEmpty(this.mac)) {
                String[] macs;
                for (String s : macs = this.mac.split("-")) {
                    buffer.putInt(Integer.parseInt(s, 16), 8);
                }
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.mac = String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase() + "-" + String.format("%02x", buffer.getIntUnsigned(8)).toUpperCase();
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetReaderMac{mac='" + this.mac + '\'' + '}';
    }
}

