/*
 * Decompiled with CFR 0.152.
 */
package me.weyye.hipermission;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import me.weyye.hipermission.PermissionActivity;
import me.weyye.hipermission.PermissionCallback;
import me.weyye.hipermission.PermissionItem;
import me.weyye.hipermission.R;

public class HiPermission {
    private final Context mContext;
    private String mTitle;
    private String mMsg;
    private int mStyleResId = -1;
    private PermissionCallback mCallback;
    private List<PermissionItem> mCheckPermissions;
    private int mPermissionType;
    private String[] mNormalPermissionNames;
    private String[] mNormalPermissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.ACCESS_FINE_LOCATION", "android.permission.CAMERA"};
    private int[] mNormalPermissionIconRes = new int[]{R.drawable.permission_ic_storage, R.drawable.permission_ic_location, R.drawable.permission_ic_camera};
    private int mFilterColor = 0;
    private int mAnimStyleId = -1;

    public static HiPermission create(Context context) {
        return new HiPermission(context);
    }

    public HiPermission(Context context) {
        this.mContext = context;
        this.mNormalPermissionNames = this.mContext.getResources().getStringArray(R.array.permissionNames);
    }

    public HiPermission title(String title) {
        this.mTitle = title;
        return this;
    }

    public HiPermission msg(String msg) {
        this.mMsg = msg;
        return this;
    }

    public HiPermission permissions(List<PermissionItem> permissionItems) {
        this.mCheckPermissions = permissionItems;
        return this;
    }

    public HiPermission filterColor(int color) {
        this.mFilterColor = color;
        return this;
    }

    public HiPermission animStyle(int styleId) {
        this.mAnimStyleId = styleId;
        return this;
    }

    public HiPermission style(int styleResIdsId) {
        this.mStyleResId = styleResIdsId;
        return this;
    }

    private List<PermissionItem> getNormalPermissions() {
        ArrayList<PermissionItem> permissionItems = new ArrayList<PermissionItem>();
        for (int i = 0; i < this.mNormalPermissionNames.length; ++i) {
            permissionItems.add(new PermissionItem(this.mNormalPermissions[i], this.mNormalPermissionNames[i], this.mNormalPermissionIconRes[i]));
        }
        return permissionItems;
    }

    public static boolean checkPermission(Context context, String permission2) {
        int checkPermission = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
        return checkPermission == 0;
    }

    public void checkMutiPermission(PermissionCallback callback) {
        if (Build.VERSION.SDK_INT < 23) {
            if (callback != null) {
                callback.onFinish();
            }
            return;
        }
        if (this.mCheckPermissions == null) {
            this.mCheckPermissions = new ArrayList<PermissionItem>();
            this.mCheckPermissions.addAll(this.getNormalPermissions());
        }
        ListIterator<PermissionItem> iterator = this.mCheckPermissions.listIterator();
        while (iterator.hasNext()) {
            if (!HiPermission.checkPermission(this.mContext, ((PermissionItem)iterator.next()).Permission)) continue;
            iterator.remove();
        }
        this.mCallback = callback;
        if (this.mCheckPermissions.size() > 0) {
            this.startActivity();
        } else if (callback != null) {
            callback.onFinish();
        }
    }

    public void checkSinglePermission(String permission2, PermissionCallback callback) {
        if (Build.VERSION.SDK_INT < 23 || HiPermission.checkPermission(this.mContext, permission2)) {
            if (callback != null) {
                callback.onGuarantee(permission2, 0);
            }
            return;
        }
        this.mCallback = callback;
        this.mPermissionType = PermissionActivity.PERMISSION_TYPE_SINGLE;
        this.mCheckPermissions = new ArrayList<PermissionItem>();
        this.mCheckPermissions.add(new PermissionItem(permission2));
        this.startActivity();
    }

    private void startActivity() {
        PermissionActivity.setCallBack(this.mCallback);
        Intent intent = new Intent(this.mContext, PermissionActivity.class);
        intent.putExtra("data_title", this.mTitle);
        intent.putExtra("data_permission_type", this.mPermissionType);
        intent.putExtra("data_msg", this.mMsg);
        intent.putExtra("data_color_filter", this.mFilterColor);
        intent.putExtra("data_style_id", this.mStyleResId);
        intent.putExtra("data_anim_style", this.mAnimStyleId);
        intent.putExtra("data_permissions", (Serializable)((Object)this.mCheckPermissions));
        intent.addFlags(0x10000000);
        this.mContext.startActivity(intent);
    }
}

