/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetBaseVersion
extends Message {
    private String baseVersions;

    public MsgAppGetBaseVersion() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = 1;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetBaseVersion(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.baseVersions = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getBaseVersions() {
        return this.baseVersions;
    }

    public void setBaseVersions(String baseVersions) {
        this.baseVersions = baseVersions;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (null != this.baseVersions) {
                String[] visions;
                for (String vs : visions = this.baseVersions.split("\\.")) {
                    buffer.putInt(Integer.parseInt(vs), 8);
                }
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.baseVersions = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetBaseVersion{baseVersions='" + this.baseVersions + '\'' + '}';
    }
}

