/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.Crc16Utils;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.HexUtils;

public class Message {
    public static final int MSG_MAX_LEN = 1024;
    public static final byte HEAD = 90;
    public MsgType msgType = null;
    public int rs485Address = 0;
    public int dataLen = 0;
    public byte[] cData = null;
    public byte[] crc = null;
    public byte[] crcData = null;
    public byte[] msgData = null;
    private byte rtCode = (byte)-1;
    private String rtMsg = "";

    public byte getRtCode() {
        return this.rtCode;
    }

    public String getRtMsg() {
        return this.rtMsg;
    }

    public void setRtCode(byte rtCode) {
        this.rtCode = rtCode;
    }

    public void setRtMsg(String rtMsg) {
        this.rtMsg = rtMsg;
    }

    public Message() {
    }

    public Message(byte[] data) {
        try {
            this.msgData = data;
            this.crcData = new byte[data.length - 3];
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(8);
            byte[] bMsgType = new byte[4];
            bMsgType = buffer.get(bMsgType);
            this.msgType = new MsgType(bMsgType);
            if (this.msgType.mt_13.equals("1")) {
                this.rs485Address = buffer.getIntUnsigned(8);
            }
            this.dataLen = buffer.getIntUnsigned(16);
            if (this.dataLen > 0) {
                this.cData = new byte[this.dataLen];
                this.cData = buffer.get(this.cData);
            }
            int oPosition = buffer.position();
            buffer.position(8);
            this.crcData = buffer.get(this.crcData);
            buffer.position(oPosition);
            this.crc = new byte[2];
            this.crc = buffer.get(this.crc);
        }
        catch (Exception e) {
            GLog.e("Message unpacking error :" + e.getStackTrace());
        }
    }

    public byte[] toBytes() {
        return this.toBytes(false);
    }

    public byte[] toBytes(boolean is485) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.put((byte)90);
        buffer.put(this.msgType.toBytes());
        if (is485) {
            buffer.putInt(this.rs485Address, 8);
        }
        buffer.putInt(this.dataLen, 16);
        if (null != this.cData && this.cData.length > 0 && this.cData.length == this.dataLen) {
            buffer.put(this.cData);
        }
        int oPosition = buffer.position();
        this.crcData = new byte[buffer.position() / 8 - 1];
        buffer.position(8);
        this.crcData = buffer.get(this.crcData);
        buffer.position(oPosition);
        this.crc = HexUtils.short2Bytes(Crc16Utils.CRC_XModem(this.crcData));
        buffer.put(this.crc);
        this.msgData = buffer.asByteArray();
        return this.msgData;
    }

    public void pack() {
        this.dataLen = 0;
    }

    public void ackPack() {
        this.crcData = new byte[]{this.rtCode};
        this.dataLen = 1;
    }

    public void ackUnpack() {
    }

    public void ackUnpack(byte[] data) {
        this.cData = data;
        this.ackUnpack();
    }

    public boolean checkCrc() {
        try {
            if (null != this.crcData && null != this.crc) {
                byte[] bCrc = HexUtils.short2Bytes(Crc16Utils.CRC_XModem(this.crcData));
                for (int i = 0; i < bCrc.length; ++i) {
                    if (this.crc[i] == bCrc[i]) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

