/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeUtils {
    public static long duration(Date end, Date start) {
        return end.getTime() - start.getTime();
    }

    public static long durationS(Date end, Date start) {
        return DateTimeUtils.duration(end, start) / 1000L;
    }

    public static long elapse(Date begin) {
        return DateTimeUtils.duration(new Date(), begin);
    }

    public static long elapseS(Date begin) {
        return DateTimeUtils.durationS(new Date(), begin);
    }

    public static long UTC(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        Date start = calendar.getTime();
        return DateTimeUtils.duration(date, start);
    }

    public static long UtcFromTimeZone(Date date, TimeZone tz) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        Date start = calendar.getTime();
        Calendar sCalendar = Calendar.getInstance(tz);
        sCalendar.setTime(date);
        sCalendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        return DateTimeUtils.duration(sCalendar.getTime(), start);
    }

    public static long UTCS(Date date) {
        return (DateTimeUtils.UTC(date) + 500L) / 1000L;
    }

    public static Date fromUTC(long utc) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        Date start = calendar.getTime();
        long begin = start.getTime();
        calendar.setTimeInMillis(begin + utc);
        return calendar.getTime();
    }

    public static Date fromUtcToTimeZone(long utc, TimeZone tz) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        Date start = calendar.getTime();
        long begin = start.getTime();
        calendar.setTimeInMillis(begin + utc);
        calendar.setTimeZone(tz);
        return calendar.getTime();
    }

    public static Date fromUTCS(long utc) {
        return DateTimeUtils.fromUTC(utc * 1000L);
    }
}

