/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgTestGetRssiCalibration
extends Message {
    private int rssiBaseValue;

    public MsgTestGetRssiCalibration() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)9;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestGetRssiCalibration(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.rssiBaseValue = buffer.getInt(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRssiBaseValue() {
        return this.rssiBaseValue;
    }

    public void setRssiBaseValue(int rssiBaseValue) {
        this.rssiBaseValue = rssiBaseValue;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putInt(this.rssiBaseValue, 16);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.rssiBaseValue = buffer.getInt(16);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgTestRssiCalibrationGet{rssiBaseValue=" + this.rssiBaseValue + '}';
    }
}

