/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseWriteGb
extends Message {
    private Long antennaEnable;
    private int area;
    private int start;
    private String hexWriteData;
    private byte[] bwriteData;
    private ParamEpcFilter filter;
    private String hexPassword;
    private int safeCertificationFlag = Integer.MAX_VALUE;
    private int fdMicrochipInitMode = Integer.MAX_VALUE;
    private int stayCarrierWave = Integer.MAX_VALUE;
    private int errorIndex;

    public MsgBaseWriteGb() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)81;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseWriteGb(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.area = buffer.getIntUnsigned(8);
            this.start = buffer.getIntUnsigned(16);
            int len = buffer.getIntUnsigned(16);
            if (len > 0) {
                this.bwriteData = buffer.get(new byte[len]);
                this.hexWriteData = HexUtils.bytes2HexString(this.bwriteData);
            }
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int filLen = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[filLen];
                        if (filLen <= 0) break;
                        buffer.get(paramData);
                        this.filter = new ParamEpcFilter(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[4];
                        buffer.get(paramData);
                        this.hexPassword = HexUtils.bytes2HexString(paramData);
                        break;
                    }
                    case 3: {
                        this.safeCertificationFlag = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 4: {
                        this.fdMicrochipInitMode = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 5: {
                        this.stayCarrierWave = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getHexWriteData() {
        return this.hexWriteData;
    }

    public void setHexWriteData(String hexWriteData) {
        if (!StringUtils.isNullOfEmpty(hexWriteData)) {
            this.hexWriteData = hexWriteData;
            this.bwriteData = HexUtils.hexString2Bytes(this.hexWriteData);
        }
    }

    public byte[] getBwriteData() {
        return this.bwriteData;
    }

    public void setBwriteData(byte[] bwriteData) {
        this.bwriteData = bwriteData;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public int getSafeCertificationFlag() {
        return this.safeCertificationFlag;
    }

    public void setSafeCertificationFlag(int safeCertificationFlag) {
        this.safeCertificationFlag = safeCertificationFlag;
    }

    public int getFdMicrochipInitMode() {
        return this.fdMicrochipInitMode;
    }

    public void setFdMicrochipInitMode(int fdMicrochipInitMode) {
        this.fdMicrochipInitMode = fdMicrochipInitMode;
    }

    public int getStayCarrierWave() {
        return this.stayCarrierWave;
    }

    public void setStayCarrierWave(int stayCarrierWave) {
        this.stayCarrierWave = stayCarrierWave;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    @Override
    public void pack() {
        byte[] tmpByte;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        buffer.putLong(this.area, 8);
        buffer.putLong(this.start, 16);
        if (null != this.bwriteData && this.bwriteData.length > 0) {
            buffer.putInt(this.bwriteData.length, 16);
            buffer.put(this.bwriteData);
        }
        if (null != this.filter) {
            buffer.putInt(1, 8);
            tmpByte = this.filter.toBytes();
            buffer.putInt(tmpByte.length, 16);
            buffer.put(tmpByte);
        }
        if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
            buffer.putInt(2, 8);
            tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
            buffer.put(tmpByte);
        }
        if (Integer.MAX_VALUE != this.safeCertificationFlag) {
            buffer.putInt(3, 8);
            buffer.putInt(this.safeCertificationFlag, 8);
        }
        if (Integer.MAX_VALUE != this.fdMicrochipInitMode) {
            buffer.putInt(4, 8);
            buffer.putInt(this.fdMicrochipInitMode, 8);
        }
        if (Integer.MAX_VALUE != this.stayCarrierWave) {
            buffer.putInt(5, 8);
            buffer.putInt(this.stayCarrierWave, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "Write parameter error.");
                this.put((byte)4, "CRC check error.");
                this.put((byte)5, "Underpower error.");
                this.put((byte)6, "Data area overflow.");
                this.put((byte)7, "Data area locked.");
                this.put((byte)8, "Access password error.");
                this.put((byte)9, "Permission denied.");
                this.put((byte)10, "Identify failure.");
                this.put((byte)11, "Other error.");
                this.put((byte)12, "Label is missing.");
                this.put((byte)13, "Send command error.");
            }
        };
        if (null != this.cData && this.cData.length >= 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
        if (null != this.cData && this.cData.length > 1) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(8);
            if (buffer.getIntUnsigned(8) == 1) {
                this.errorIndex = buffer.getIntUnsigned(16);
            }
        }
    }
}

