/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.HashMap;

public class MsgTestPowerCalibration
extends Message {
    private int childFreqRange;
    private int power;
    private int powerParam;
    private int optionType;

    public MsgTestPowerCalibration() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)3;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestPowerCalibration(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.childFreqRange = buffer.getIntUnsigned(8);
            this.power = buffer.getIntUnsigned(8);
            this.powerParam = buffer.getIntUnsigned(8);
            this.optionType = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getChildFreqRange() {
        return this.childFreqRange;
    }

    public void setChildFreqRange(int childFreqRange) {
        this.childFreqRange = childFreqRange;
    }

    public int getPower() {
        return this.power;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public int getPowerParam() {
        return this.powerParam;
    }

    public void setPowerParam(int powerParam) {
        this.powerParam = powerParam;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public void setOptionType(int optionType) {
        this.optionType = optionType;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.childFreqRange, 8);
        buffer.putLong(this.power, 8);
        buffer.putLong(this.powerParam, 8);
        buffer.putLong(this.optionType, 8);
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        HashMap<Byte, String> dicErrorMsg = new HashMap<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Save failure.");
                this.put((byte)2, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

