/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

import com.gg.reader.api.utils.ArrayBitBuffer;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.SimpleBitBuffer;

public class DynamicBitBuffer
extends SimpleBitBuffer {
    private static final int DEFAULT_CAPACITY = 256;
    private byte[] bytes;

    protected DynamicBitBuffer() {
        this.bytes = new byte[256];
    }

    protected DynamicBitBuffer(int initialCapacity) {
        this.bytes = new byte[DynamicBitBuffer.toBytes(initialCapacity)];
    }

    private static int toBytes(int bits) {
        return (bits + (8 - bits % 8)) / 8;
    }

    @Override
    protected byte rawGet(int index) {
        if (index >= this.bytes.length) {
            this.ensureCapacity(index + 1);
        }
        return this.bytes[index];
    }

    private void ensureCapacity(int toBytes) {
        byte[] newBytes = new byte[toBytes];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.bytes.length);
        this.bytes = newBytes;
    }

    @Override
    protected void rawSet(int index, byte value) {
        if (index >= this.bytes.length) {
            this.ensureCapacity(index + 1);
        }
        this.bytes[index] = value;
    }

    @Override
    protected int rawLength() {
        return this.bytes.length * 8;
    }

    @Override
    public BitBuffer slice() {
        return new ArrayBitBuffer(this.bytes, this.size() - this.position(), this.position());
    }

    @Override
    public BitBuffer slice(int start, int length) {
        return new ArrayBitBuffer(this.bytes, Math.min(length, this.size() - start), start);
    }

    @Override
    public BitBuffer slice(int start) {
        return this.slice(start, this.size() - start);
    }
}

