/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgTestSetReaderWorkMode
extends Message {
    private int workMode;
    private int baudRate485 = Integer.MAX_VALUE;
    private int dataBit485 = Integer.MAX_VALUE;
    private int parityBit485 = Integer.MAX_VALUE;
    private int stopBit485 = Integer.MAX_VALUE;
    private int baudRate232 = Integer.MAX_VALUE;

    public MsgTestSetReaderWorkMode() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)17;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestSetReaderWorkMode(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.workMode = buffer.getInt(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.baudRate485 = buffer.getIntUnsigned(8);
                        this.dataBit485 = buffer.getIntUnsigned(8);
                        this.parityBit485 = buffer.getIntUnsigned(8);
                        this.stopBit485 = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.baudRate232 = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWorkMode() {
        return this.workMode;
    }

    public void setWorkMode(int workMode) {
        this.workMode = workMode;
    }

    public int getBaudRate485() {
        return this.baudRate485;
    }

    public void setBaudRate485(int baudRate485) {
        this.baudRate485 = baudRate485;
    }

    public int getDataBit485() {
        return this.dataBit485;
    }

    public void setDataBit485(int dataBit485) {
        this.dataBit485 = dataBit485;
    }

    public int getParityBit485() {
        return this.parityBit485;
    }

    public void setParityBit485(int parityBit485) {
        this.parityBit485 = parityBit485;
    }

    public int getStopBit485() {
        return this.stopBit485;
    }

    public void setStopBit485(int stopBit485) {
        this.stopBit485 = stopBit485;
    }

    public int getBaudRate232() {
        return this.baudRate232;
    }

    public void setBaudRate232(int baudRate232) {
        this.baudRate232 = baudRate232;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(this.workMode, 8);
        if (Integer.MAX_VALUE != this.baudRate485) {
            buffer.putInt(1, 8);
            buffer.putInt(this.baudRate485, 8);
        }
        if (Integer.MAX_VALUE != this.dataBit485) {
            buffer.putInt(this.dataBit485, 8);
        }
        if (Integer.MAX_VALUE != this.parityBit485) {
            buffer.putInt(this.parityBit485, 8);
        }
        if (Integer.MAX_VALUE != this.stopBit485) {
            buffer.putInt(this.stopBit485, 8);
        }
        if (Integer.MAX_VALUE != this.baudRate232) {
            buffer.putInt(2, 8);
            buffer.putInt(this.baudRate232, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Set success.");
                this.put((byte)1, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

