/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import cn.pda.serialport.SerialPort;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class AndroidPdaSerialClient
extends CommunicationInterface {
    private boolean isOpen = false;
    private int iDelay = 100;
    private InputStream mInputStream;
    private OutputStream mOutputStream;
    private SerialPort mSerialPort;
    private String sPort = "/dev/ttyMT1";
    private int port = 13;
    private int baudrate = 115200;

    public AndroidPdaSerialClient() {
    }

    public AndroidPdaSerialClient(String paramString, int paramInt) {
        this.sPort = paramString;
        this.baudrate = paramInt;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] paramArrayOfByte) {
        Class<AndroidPdaSerialClient> clazz = AndroidPdaSerialClient.class;
        synchronized (AndroidPdaSerialClient.class) {
            try {
                this.mOutputStream.write(paramArrayOfByte);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) {
        Class<AndroidPdaSerialClient> clazz = AndroidPdaSerialClient.class;
        synchronized (AndroidPdaSerialClient.class) {
            try {
                if (this.isRs485) {
                    msg.msgType.mt_13 = "1";
                    msg.rs485Address = this.getRs485Address();
                }
                msg.pack();
                byte[] sendData = msg.toBytes(this.isRs485);
                this.send(sendData);
            }
            catch (Exception ex) {
                GLog.e("[AndroidPdaSerialClient]base serial send error:" + ex.getMessage());
            }
            return;
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            String[] arrParam = param.split(":");
            if (arrParam.length == 2) {
                this.port = Integer.parseInt(arrParam[0]);
                this.baudrate = Integer.parseInt(arrParam[1]);
                this.mSerialPort = new SerialPort(this.port, this.baudrate, 0);
                this.mOutputStream = this.mSerialPort.getOutputStream();
                this.mInputStream = this.mSerialPort.getInputStream();
                this.isOpen = true;
                this.keepReceived = true;
                this.startReceive();
                this.startProcess();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.isOpen = false;
            this.keepReceived = false;
            if (this.mSerialPort != null) {
                this.mSerialPort.close(this.port);
                this.mInputStream = null;
                this.mOutputStream = null;
                this.mSerialPort = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void hdPowerOn() {
        super.hdPowerOn();
        if (this.mSerialPort != null) {
            this.mSerialPort.power_5Von();
        }
    }

    @Override
    public void hdPowerOff() {
        super.hdPowerOff();
        if (this.mSerialPort != null) {
            this.mSerialPort.power_5Voff();
        }
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (AndroidPdaSerialClient.this.keepReceived) {
                    try {
                        if (AndroidPdaSerialClient.this.mInputStream != null) {
                            int len = AndroidPdaSerialClient.this.mInputStream.available();
                            if (len <= 0) {
                                Thread.sleep(AndroidPdaSerialClient.this.iDelay);
                            }
                            if (len <= 0) continue;
                            len = AndroidPdaSerialClient.this.mInputStream.read(AndroidPdaSerialClient.this.rcvBuff, 0, AndroidPdaSerialClient.this.rcvBuff.length);
                            Object object = AndroidPdaSerialClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (len + AndroidPdaSerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    AndroidPdaSerialClient.this.lockRingBuffer.wait(10000L);
                                }
                                AndroidPdaSerialClient.this.ringBuffer.WriteBuffer(AndroidPdaSerialClient.this.rcvBuff, 0, len);
                                AndroidPdaSerialClient.this.lockRingBuffer.notify();
                                continue;
                            }
                        }
                        break;
                    }
                    catch (Exception ex) {
                        GLog.e("[AndroidPdaSerialClient]startReceive error.");
                    }
                }
            }
        });
    }
}

