/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamGbAntiCollision;
import com.gg.reader.api.protocol.gx.ParamGbBaseSpeed;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetGbBaseband
extends Message {
    private ParamGbBaseSpeed paramGbBaseSpeed;
    private ParamGbAntiCollision paramGbAntiCollision;
    private int session = Integer.MAX_VALUE;
    private int inventoryFlag = Integer.MAX_VALUE;

    public MsgBaseGetGbBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-29;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetGbBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            byte[] paramData = new byte[1];
            buffer.get(paramData);
            this.paramGbBaseSpeed = new ParamGbBaseSpeed(paramData);
            paramData = new byte[1];
            buffer.get(paramData);
            this.paramGbAntiCollision = new ParamGbAntiCollision(paramData);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ParamGbBaseSpeed getParamGbBaseSpeed() {
        return this.paramGbBaseSpeed;
    }

    public void setParamGbBaseSpeed(ParamGbBaseSpeed paramGbBaseSpeed) {
        this.paramGbBaseSpeed = paramGbBaseSpeed;
    }

    public ParamGbAntiCollision getParamGbAntiCollision() {
        return this.paramGbAntiCollision;
    }

    public void setParamGbAntiCollision(ParamGbAntiCollision paramGbAntiCollision) {
        this.paramGbAntiCollision = paramGbAntiCollision;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            byte[] bytes;
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (null != this.paramGbBaseSpeed) {
                bytes = this.paramGbBaseSpeed.toBytes();
                buffer.put(bytes);
            }
            if (null != this.paramGbAntiCollision) {
                bytes = this.paramGbAntiCollision.toBytes();
                buffer.put(bytes);
            }
            if (Integer.MAX_VALUE != this.session) {
                buffer.putLong(this.session, 8);
            }
            if (Integer.MAX_VALUE != this.inventoryFlag) {
                buffer.putLong(this.inventoryFlag, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            byte[] paramData = new byte[1];
            buffer.get(paramData);
            this.paramGbBaseSpeed = new ParamGbBaseSpeed(paramData);
            paramData = new byte[1];
            buffer.get(paramData);
            this.paramGbAntiCollision = new ParamGbAntiCollision(paramData);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetGbBaseband{paramGbBaseSpeed=" + this.paramGbBaseSpeed + ", paramGbAntiCollision=" + this.paramGbAntiCollision + ", session=" + this.session + ", inventoryFlag=" + this.inventoryFlag + '}';
    }
}

