/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal;

import com.gg.reader.api.dal.HandlerDebugLog;
import com.gg.reader.api.dal.HandlerUdpMulticast;
import com.gg.reader.api.entity.GMulticast;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class GUdpMulticast {
    private MulticastSocket ms = null;
    private DatagramPacket dataPacket = null;
    private Boolean keepReceive = false;
    private InetAddress address;
    private String _GroupIP = "230.1.1.168";
    private int _GroupPort = 8161;
    private int index = 0;
    public HandlerUdpMulticast handlerUdpMulticast;
    public HandlerDebugLog debugLog;

    public GUdpMulticast(String _GroupIP, int _GroupPort, int timeout) {
        try {
            this._GroupIP = _GroupIP;
            this._GroupPort = _GroupPort;
            this.ms = new MulticastSocket(this._GroupPort);
            this.ms.setSoTimeout(timeout);
            this.address = InetAddress.getByName(this._GroupIP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void triggerOnUdpMulticast(GMulticast gMulticast) {
        try {
            if (null != this.handlerUdpMulticast) {
                this.handlerUdpMulticast.log(gMulticast);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        if (!this.keepReceive.booleanValue()) {
            this.keepReceive = true;
            final List<String> nif = this.getAllNif();
            ThreadPoolUtils.run(new Runnable(){

                @Override
                public void run() {
                    while (GUdpMulticast.this.keepReceive.booleanValue()) {
                        try {
                            GUdpMulticast.this.ms.joinGroup(new InetSocketAddress(GUdpMulticast.this.address, 8161), NetworkInterface.getByName((String)nif.get(GUdpMulticast.this.index % nif.size())));
                            byte[] temp = new byte[1024];
                            GUdpMulticast.this.dataPacket = new DatagramPacket(temp, temp.length);
                            if (GUdpMulticast.this.debugLog != null) {
                                GUdpMulticast.this.debugLog.receiveDebugLog("[Udp]-->" + (String)nif.get(GUdpMulticast.this.index % nif.size()) + ":Receive");
                            }
                            GUdpMulticast.this.ms.receive(GUdpMulticast.this.dataPacket);
                            if (GUdpMulticast.this.dataPacket.getLength() > 0 && GUdpMulticast.this.debugLog != null) {
                                GUdpMulticast.this.debugLog.receiveDebugLog("[Udp]-->[" + new String(GUdpMulticast.this.dataPacket.getData(), "ASCII") + "]");
                            }
                            GMulticast gMulticast = new GMulticast(new String(GUdpMulticast.this.dataPacket.getData(), "ASCII").trim());
                            GUdpMulticast.this.triggerOnUdpMulticast(gMulticast);
                            GUdpMulticast.this.ms.leaveGroup(GUdpMulticast.this.address);
                        }
                        catch (Exception e) {
                            try {
                                GUdpMulticast.this.ms.leaveGroup(GUdpMulticast.this.address);
                                if (GUdpMulticast.this.debugLog != null) {
                                    GUdpMulticast.this.debugLog.receiveDebugLog("[Udp]-->Next network adapter");
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        GUdpMulticast.this.index++;
                    }
                }
            });
        }
    }

    public void close() {
        this.keepReceive = false;
        this.ms.close();
    }

    private List<String> getAllNif() {
        ArrayList<String> nifS = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                Enumeration<InetAddress> addresses = nif.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet4Address) || addr.getHostAddress().equals("127.0.0.1")) continue;
                    nifS.add(nif.getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nifS;
    }
}

