/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;

public class MsgAppGetWifiConnectStatus
extends Message {
    private String hotspotName;

    public MsgAppGetWifiConnectStatus() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)52;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetWifiConnectStatus(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            int hnLen = buffer.getIntUnsigned(16);
            if (hnLen > 0) {
                this.hotspotName = new String(buffer.get(new byte[hnLen]), "ASCII");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHotspotName() {
        return this.hotspotName;
    }

    public void setHotspotName(String hotspotName) {
        this.hotspotName = hotspotName;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (!StringUtils.isNullOfEmpty(this.hotspotName)) {
                buffer.putInt(this.hotspotName.length(), 16);
                buffer.put(this.hotspotName);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int hnLen = buffer.getIntUnsigned(16);
            try {
                this.hotspotName = hnLen > 0 ? new String(buffer.get(new byte[hnLen]), "ASCII") : "\u672a\u8fde\u63a5";
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetWifiConnectStatus{hotspotName='" + this.hotspotName + '\'' + '}';
    }
}

