/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetBaseband
extends Message {
    private int baseSpeed = Integer.MAX_VALUE;
    private int qValue = Integer.MAX_VALUE;
    private int session = Integer.MAX_VALUE;
    private int inventoryFlag = Integer.MAX_VALUE;

    public MsgBaseGetBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)12;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.baseSpeed = buffer.getIntUnsigned(8);
            this.qValue = buffer.getIntUnsigned(8);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(int baseSpeed) {
        this.baseSpeed = baseSpeed;
    }

    public int getqValue() {
        return this.qValue;
    }

    public void setqValue(int qValue) {
        this.qValue = qValue;
    }

    public int getSession() {
        return this.session;
    }

    public void setSession(int session) {
        this.session = session;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.baseSpeed) {
                buffer.putLong(this.baseSpeed, 8);
            }
            if (Integer.MAX_VALUE != this.qValue) {
                buffer.putLong(this.qValue, 8);
            }
            if (Integer.MAX_VALUE != this.session) {
                buffer.putLong(this.session, 8);
            }
            if (Integer.MAX_VALUE != this.inventoryFlag) {
                buffer.putLong(this.inventoryFlag, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.baseSpeed = buffer.getIntUnsigned(8);
            this.qValue = buffer.getIntUnsigned(8);
            this.session = buffer.getIntUnsigned(8);
            this.inventoryFlag = buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetBaseband{baseSpeed=" + this.baseSpeed + ", qValue=" + this.qValue + ", session=" + this.session + ", inventoryFlag=" + this.inventoryFlag + '}';
    }
}

