/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.HandlerRemoteConnected;
import com.gg.reader.api.dal.communication.TcpClient;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer {
    private ServerSocket listenSocket = null;
    public Boolean keepListen = false;
    public int listenPort = 8160;
    public HandlerRemoteConnected onRemoteConnected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerClientConnectedEvent(TcpClient client) {
        block5: {
            try {
                if (this.onRemoteConnected == null) break block5;
                HandlerRemoteConnected handlerRemoteConnected = this.onRemoteConnected;
                synchronized (handlerRemoteConnected) {
                    this.onRemoteConnected.log(client);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean open(int param) {
        if (null != this.listenSocket) {
            return false;
        }
        this.keepListen = true;
        try {
            this.listenPort = param;
            this.listenSocket = new ServerSocket();
            this.listenSocket.bind(new InetSocketAddress("0.0.0.0", this.listenPort));
            this.startListen();
            return true;
        }
        catch (Exception ex) {
            this.close();
            return false;
        }
    }

    public void startListen() {
        ThreadPoolUtils.run(new Runnable(){

            @Override
            public void run() {
                while (TcpServer.this.keepListen.booleanValue()) {
                    try {
                        Socket acSocket = TcpServer.this.listenSocket.accept();
                        TcpClient tc = new TcpClient();
                        tc.connType = 3;
                        if (tc.open(acSocket)) {
                            tc.serverIp = acSocket.getInetAddress().getHostAddress();
                            tc.serverPort = acSocket.getPort();
                            TcpServer.this.triggerClientConnectedEvent(tc);
                            continue;
                        }
                        acSocket.close();
                        tc.close();
                    }
                    catch (Exception ex) {
                        break;
                    }
                }
            }
        });
    }

    public void close() {
        this.keepListen = false;
        if (this.listenSocket != null) {
            try {
                this.listenSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

