/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.ThreadPoolUtils;
import com.rscja.deviceapi.Module;
import com.rscja.deviceapi.exception.ConfigurationException;
import java.net.Socket;

public class CWSerialClient
extends CommunicationInterface {
    private Module instance;

    public CWSerialClient() {
        try {
            this.instance = Module.getInstance();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public boolean powerOn(int module) {
        if (this.instance != null) {
            return this.instance.powerOn(module);
        }
        return false;
    }

    public boolean powerOff(int module) {
        if (this.instance != null) {
            return this.instance.powerOff(module);
        }
        return false;
    }

    public boolean init(int module) {
        if (this.instance != null) {
            return this.instance.init(module);
        }
        return false;
    }

    public boolean free() {
        if (this.instance != null) {
            return this.instance.free();
        }
        return false;
    }

    @Override
    public boolean open(String s, int i) {
        return false;
    }

    @Override
    public boolean open(Socket socket) {
        return false;
    }

    @Override
    public boolean open(String s, int i, int i1) {
        return false;
    }

    @Override
    public boolean open(String s) {
        boolean isOpen;
        if (s == null) {
            return false;
        }
        String[] split = s.split(":");
        if (this.instance != null && (isOpen = this.instance.openSerail(split[0], Integer.parseInt(split[1]), 8, 1, 0))) {
            this.keepReceived = true;
            this.startReceive();
            this.startProcess();
            return true;
        }
        return false;
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (CWSerialClient.this.keepReceived) {
                    try {
                        byte[] bytes = CWSerialClient.this.instance.receiveEx();
                        if (bytes.length <= 0) {
                            Thread.sleep(100L);
                            continue;
                        }
                        Object object = CWSerialClient.this.lockRingBuffer;
                        synchronized (object) {
                            while (bytes.length + CWSerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                                CWSerialClient.this.lockRingBuffer.wait(10000L);
                            }
                            CWSerialClient.this.ringBuffer.WriteBuffer(bytes, 0, bytes.length);
                            CWSerialClient.this.lockRingBuffer.notify();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        if (this.instance != null) {
            this.keepReceived = false;
            this.instance.closeSerail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] bytes) {
        CWSerialClient cWSerialClient = this;
        synchronized (cWSerialClient) {
            try {
                this.instance.send(bytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(Message message) {
        try {
            if (this.isRs485) {
                message.msgType.mt_13 = "1";
                message.rs485Address = this.getRs485Address();
            }
            message.pack();
            this.send(message.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] bytes) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int i) {
        return false;
    }

    @Override
    public void dispose() {
    }
}

