/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.ArrayList;
import java.util.List;

public class MsgBaseGetFrequency
extends Message {
    private Boolean automatically;
    private List<Integer> listFreqCursor;

    public MsgBaseGetFrequency() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)6;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetFrequency(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.automatically = buffer.getIntUnsigned(8) == 1;
            if (null == this.listFreqCursor) {
                this.listFreqCursor = new ArrayList<Integer>();
            }
            int len = buffer.getIntUnsigned(16);
            for (int i = 0; i < len; ++i) {
                this.listFreqCursor.add(buffer.getIntUnsigned(8));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Boolean getAutomatically() {
        return this.automatically;
    }

    public void setAutomatically(Boolean automatically) {
        this.automatically = automatically;
    }

    public List<Integer> getListFreqCursor() {
        return this.listFreqCursor;
    }

    public void setListFreqCursor(List<Integer> listFreqCursor) {
        this.listFreqCursor = listFreqCursor;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putInt(this.automatically != false ? 1 : 0, 8);
            if (null != this.listFreqCursor && this.listFreqCursor.size() > 0) {
                buffer.putInt(this.listFreqCursor.size(), 16);
                for (int b : this.listFreqCursor) {
                    buffer.putLong(b, 8);
                }
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.automatically = buffer.getIntUnsigned(8) == 1;
            if (null == this.listFreqCursor) {
                this.listFreqCursor = new ArrayList<Integer>();
            }
            int len = buffer.getIntUnsigned(16);
            for (int i = 0; i < len; ++i) {
                this.listFreqCursor.add(buffer.getIntUnsigned(8));
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetFrequency{automatically=" + this.automatically + ", listFreqCursor=" + this.listFreqCursor + '}';
    }
}

