/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseLock6bGet
extends Message {
    private Long antennaEnable;
    private String hexMatchTid;
    private byte[] bMatchTid;
    private int lockIndex;
    private int lockState;

    public MsgBaseLock6bGet() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)67;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseLock6bGet(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.bMatchTid = buffer.get(new byte[8]);
            this.hexMatchTid = HexUtils.bytes2HexString(this.bMatchTid);
            this.lockIndex = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public String getHexMatchTid() {
        return this.hexMatchTid;
    }

    public void setHexMatchTid(String hexMatchTid) {
        if (!StringUtils.isNullOfEmpty(hexMatchTid)) {
            this.hexMatchTid = hexMatchTid;
            this.bMatchTid = HexUtils.hexString2Bytes(this.hexMatchTid);
        }
    }

    public byte[] getbMatchTid() {
        return this.bMatchTid;
    }

    public void setbMatchTid(byte[] bMatchTid) {
        this.bMatchTid = bMatchTid;
    }

    public int getLockIndex() {
        return this.lockIndex;
    }

    public void setLockIndex(int lockIndex) {
        this.lockIndex = lockIndex;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setLockState(int lockState) {
        this.lockState = lockState;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            if (null != this.bMatchTid && this.bMatchTid.length > 0) {
                buffer.put(this.bMatchTid);
            }
            buffer.putLong(this.lockIndex, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackPack() {
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
            if (this.cData.length > 1) {
                BitBuffer buffer = BitBuffer.wrap(this.cData);
                buffer.position(8);
                if (buffer.getIntUnsigned(8) == 1) {
                    this.lockState = buffer.getIntUnsigned(8);
                }
            }
        }
    }
}

