/*
 * Decompiled with CFR 0.152.
 */
package com.uhf.lcrrgxmodule.factory;

import android.bld.rfid.aidl.BaseInfo;
import android.bld.rfid.aidl.QueryInfo;
import android.bld.rfid.aidl.TagData;
import android.media.SoundPool;
import android.os.SystemClock;
import android.util.Log;
import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.dal.HandlerTagEpcLog;
import com.gg.reader.api.dal.HandlerTagEpcOver;
import com.gg.reader.api.protocol.gx.LogBaseEpcInfo;
import com.gg.reader.api.protocol.gx.LogBaseEpcOver;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppGetBaseVersion;
import com.gg.reader.api.protocol.gx.MsgBaseDestroyEpc;
import com.gg.reader.api.protocol.gx.MsgBaseGetBaseband;
import com.gg.reader.api.protocol.gx.MsgBaseGetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseGetFrequency;
import com.gg.reader.api.protocol.gx.MsgBaseGetPower;
import com.gg.reader.api.protocol.gx.MsgBaseInventoryEpc;
import com.gg.reader.api.protocol.gx.MsgBaseLockEpc;
import com.gg.reader.api.protocol.gx.MsgBaseSetBaseband;
import com.gg.reader.api.protocol.gx.MsgBaseSetFreqRange;
import com.gg.reader.api.protocol.gx.MsgBaseSetPower;
import com.gg.reader.api.protocol.gx.MsgBaseStop;
import com.gg.reader.api.protocol.gx.MsgBaseWriteEpc;
import com.gg.reader.api.protocol.gx.MsgTestCarrierWave;
import com.gg.reader.api.protocol.gx.MsgTestVSWRcheck;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.protocol.gx.ParamEpcReadEpc;
import com.gg.reader.api.protocol.gx.ParamEpcReadReserved;
import com.gg.reader.api.protocol.gx.ParamEpcReadTid;
import com.gg.reader.api.protocol.gx.ParamEpcReadUserdata;
import com.gg.reader.api.utils.HexUtils;
import com.rfid.InventoryTagMap;
import com.rfid.InventoryTagResult;
import com.rfid.trans.PcUtils;
import com.rfid.trans.ReadTag;
import com.rfid.trans.ReaderParameter;
import com.rfid.trans.TagCallback;
import com.uhf.lcrrgxmodule.factory.ILcUhfProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GxUhfProduct
implements ILcUhfProduct {
    private final String TAG = "bldAdd#" + GxUhfProduct.class.getSimpleName();
    private GClient client = new GClient();
    private volatile boolean isSound = false;
    private Integer soundid = null;
    private SoundPool soundPool = null;
    public String devName = "";
    private volatile boolean soundworking = true;
    private volatile Thread sThread = null;
    private TagCallback callback;
    private ReaderParameter param = new ReaderParameter();
    public static List<InventoryTagMap> lsTagList = new ArrayList<InventoryTagMap>();
    public static List<InventoryTagResult> lsList = new ArrayList<InventoryTagResult>();
    private final Object[] lock = new Object[0];
    private volatile Thread tagThread = null;
    private ConcurrentLinkedQueue<ReadTag> queue = new ConcurrentLinkedQueue();
    private static String devport = "/dev/ttyS3";
    private static String devport2 = "/dev/ttyS2";
    private String singleData = "";
    private int singleArea = -1;

    @Override
    public void beginSound(boolean sound) {
        this.isSound = sound;
    }

    @Override
    public void setsoundid(int id, SoundPool soundPool) {
        this.soundid = id;
        this.soundPool = soundPool;
    }

    @Override
    public void playSound() {
        if (this.soundid == null || this.soundPool == null) {
            return;
        }
        try {
            this.soundPool.play(this.soundid.intValue(), 1.0f, 1.0f, 1, 0, 1.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int Connect() {
        String ComPort = devport;
        int BaudRate = 115200;
        int result = this.Connect(ComPort, BaudRate);
        if (result != 0) {
            result = this.Connect(ComPort, 460800);
        }
        if (result != 0) {
            result = this.Connect(devport2, BaudRate);
        }
        return result;
    }

    @Override
    public int Connect(String ComPort, int BaudRate) {
        if (this.client.openAndroidSerial(ComPort + ":" + BaudRate, 0)) {
            Log.e((String)this.TAG, (String)("Connect Successfully ComPort-BaudRate(" + ComPort + ":" + BaudRate + ")"));
            MsgBaseStop stop = new MsgBaseStop();
            this.client.sendSynMsg((Message)stop);
            if (stop.getRtCode() != 0) {
                this.client.close();
                return stop.getRtCode();
            }
            this.devName = ComPort;
            this.isSound = false;
            this.soundworking = true;
            this.sThread = new Thread(() -> {
                while (this.soundworking) {
                    if (!this.isSound) continue;
                    this.playSound();
                    SystemClock.sleep((long)50L);
                }
            });
            this.sThread.start();
            this.tagThread = new Thread(() -> {
                while (this.soundworking) {
                    ReadTag poll = this.queue.poll();
                    if (this.callback == null) continue;
                    this.callback.tagCallback(poll);
                }
            });
            this.tagThread.start();
            return 0;
        }
        return -1;
    }

    @Override
    public int DisConnect() {
        try {
            this.isSound = false;
            this.soundworking = false;
            this.sThread.interrupt();
            this.sThread = null;
            this.tagThread.interrupt();
            this.tagThread = null;
            this.queue.clear();
            if (this.soundPool != null) {
                this.soundPool.release();
                this.soundPool = null;
            }
            if (lsTagList != null) {
                lsTagList.clear();
            }
            if (lsList != null) {
                lsList.clear();
            }
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)("DisConnect Exception=" + ex.getMessage()));
        }
        return this.client.close() ? 0 : -1;
    }

    @Override
    public void SetInventoryParameter(ReaderParameter param) {
        this.param = param;
    }

    @Override
    public ReaderParameter GetInventoryParameter() {
        return this.param;
    }

    @Override
    public int GetUHFInformation(byte[] Version, byte[] Power, byte[] band, byte[] MaxFre, byte[] MinFre, byte[] BeepEn, byte[] Ant) {
        MsgAppGetBaseVersion getBaseVersion = new MsgAppGetBaseVersion();
        this.client.sendSynMsg((Message)getBaseVersion);
        if (getBaseVersion.getRtCode() != 0) {
            return getBaseVersion.getRtCode();
        }
        String[] split = getBaseVersion.getBaseVersions().split("\\.");
        Version[0] = Byte.parseByte(split[0]);
        Version[1] = Byte.parseByte(split[1]);
        Version[2] = Byte.parseByte(split[2]);
        Version[3] = Byte.parseByte(split[3]);
        MsgBaseGetPower getPower = new MsgBaseGetPower();
        this.client.sendSynMsg((Message)getPower);
        if (getPower.getRtCode() != 0) {
            return getPower.getRtCode();
        }
        Power[0] = ((Integer)getPower.getDicPower().get(1)).byteValue();
        MsgBaseGetFreqRange getFreqRange = new MsgBaseGetFreqRange();
        this.client.sendSynMsg((Message)getFreqRange);
        if (getFreqRange.getRtCode() != 0) {
            return getFreqRange.getRtCode();
        }
        switch (getFreqRange.getFreqRangeIndex()) {
            case 0: {
                band[0] = 1;
                break;
            }
            case 1: {
                band[0] = 8;
                break;
            }
            case 2: {
                band[0] = 3;
                break;
            }
            case 3: {
                band[0] = 2;
                break;
            }
            case 4: {
                band[0] = 4;
            }
        }
        MsgBaseGetFrequency getFrequency = new MsgBaseGetFrequency();
        this.client.sendSynMsg((Message)getFrequency);
        if (getFreqRange.getRtCode() != 0) {
            return getFreqRange.getRtCode();
        }
        List listFreqCursor = getFrequency.getListFreqCursor();
        Collections.sort(listFreqCursor);
        MaxFre[0] = ((Integer)listFreqCursor.get(0)).byteValue();
        MinFre[0] = ((Integer)listFreqCursor.get(listFreqCursor.size() - 1)).byteValue();
        BeepEn[0] = 0;
        return 0;
    }

    @Override
    public int SetRfPower(int Power) {
        MsgBaseSetPower msg = new MsgBaseSetPower();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        hashtable.put(1, Power);
        msg.setDicPower(hashtable);
        this.client.sendSynMsg((Message)msg);
        return msg.getRtCode();
    }

    @Override
    public int SetRegion(int band, int maxfre, int minfre) {
        MsgBaseSetFreqRange msg = new MsgBaseSetFreqRange();
        switch (band) {
            case 1: {
                msg.setFreqRangeIndex(0);
                break;
            }
            case 2: {
                msg.setFreqRangeIndex(3);
                break;
            }
            case 3: {
                msg.setFreqRangeIndex(2);
                break;
            }
            case 4: {
                msg.setFreqRangeIndex(4);
                break;
            }
            case 8: {
                msg.setFreqRangeIndex(1);
            }
        }
        MsgBaseGetFreqRange getFreqRange = new MsgBaseGetFreqRange();
        this.client.sendSynMsg((Message)getFreqRange);
        if (getFreqRange.getRtCode() != 0) {
            return getFreqRange.getRtCode();
        }
        if (getFreqRange.getFreqRangeIndex() == msg.getFreqRangeIndex()) {
            return 0;
        }
        this.client.sendSynMsg((Message)msg);
        return msg.getRtCode();
    }

    public void onSingleCallback() {
        this.client.onTagEpcLog = null;
        this.client.onTagEpcOver = null;
        this.client.onTagEpcLog = new HandlerTagEpcLog(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void log(String s, LogBaseEpcInfo logBaseEpcInfo) {
                if (logBaseEpcInfo.getResult() == 0 && GxUhfProduct.this.singleData.equals("")) {
                    switch (GxUhfProduct.this.singleArea) {
                        case 0: {
                            GxUhfProduct.this.singleData = logBaseEpcInfo.getReserved();
                            break;
                        }
                        case 1: {
                            GxUhfProduct.this.singleData = logBaseEpcInfo.getEpcData();
                            break;
                        }
                        case 2: {
                            GxUhfProduct.this.singleData = logBaseEpcInfo.getTid();
                            break;
                        }
                        case 3: {
                            GxUhfProduct.this.singleData = logBaseEpcInfo.getUserdata();
                        }
                    }
                    Object[] objectArray = GxUhfProduct.this.lock;
                    synchronized (objectArray) {
                        GxUhfProduct.this.lock.notify();
                    }
                }
            }
        };
        this.client.onTagEpcOver = new HandlerTagEpcOver(){

            public void log(String s, LogBaseEpcOver logBaseEpcOver) {
            }
        };
    }

    public void onLoopCallback() {
        this.queue.clear();
        this.client.onTagEpcLog = null;
        this.client.onTagEpcOver = null;
        this.client.onTagEpcLog = new HandlerTagEpcLog(){

            public void log(String s, LogBaseEpcInfo logBaseEpcInfo) {
                Log.d((String)GxUhfProduct.this.TAG, (String)("log: logBaseEpcInfo -->" + logBaseEpcInfo));
                if (logBaseEpcInfo.getResult() == 0) {
                    ReadTag tag = new ReadTag();
                    tag.antId = logBaseEpcInfo.getAntId();
                    tag.epcId = logBaseEpcInfo.getEpc();
                    Log.d((String)GxUhfProduct.this.TAG, (String)("log: logBaseEpcInfo.getEpc() --> " + logBaseEpcInfo.getEpc().isEmpty()));
                    if (logBaseEpcInfo.getTid() != null) {
                        tag.epcId = logBaseEpcInfo.getTid();
                    }
                    tag.rssi = logBaseEpcInfo.getRssi();
                    Log.d((String)GxUhfProduct.this.TAG, (String)("log: callback -->" + (GxUhfProduct.this.callback != null)));
                    Log.d((String)GxUhfProduct.this.TAG, (String)"log: test");
                    GxUhfProduct.this.queue.offer(tag);
                }
            }
        };
        this.client.onTagEpcOver = new HandlerTagEpcOver(){

            public void log(String s, LogBaseEpcOver logBaseEpcOver) {
                GxUhfProduct.this.isSound = false;
                if (GxUhfProduct.this.callback != null) {
                    GxUhfProduct.this.callback.FinishCallBack();
                }
            }
        };
    }

    public String ReadDataFilter(int FilterArea, String Str, byte Mem, int WordPtr, byte Num, byte[] Password) {
        this.singleData = "";
        this.singleArea = Mem;
        this.client.sendUnsynMsg((Message)new MsgBaseStop());
        this.onSingleCallback();
        MsgBaseInventoryEpc msg = new MsgBaseInventoryEpc();
        msg.setAntennaEnable(Long.valueOf(1L));
        msg.setInventoryMode(1);
        switch (Mem) {
            case 0: {
                ParamEpcReadReserved readReserved = new ParamEpcReadReserved();
                readReserved.setStart(WordPtr);
                readReserved.setLen((int)Num);
                msg.setReadReserved(readReserved);
                break;
            }
            case 1: {
                ParamEpcReadEpc readEpc = new ParamEpcReadEpc();
                readEpc.setStart(WordPtr);
                readEpc.setLen((int)Num);
                msg.setReadEpc(readEpc);
                break;
            }
            case 2: {
                ParamEpcReadTid readTid = new ParamEpcReadTid();
                readTid.setMode(1);
                readTid.setLen((int)Num);
                msg.setReadTid(readTid);
                break;
            }
            case 3: {
                ParamEpcReadUserdata readUserdata = new ParamEpcReadUserdata();
                readUserdata.setStart(WordPtr);
                readUserdata.setLen((int)Num);
                msg.setReadUserdata(readUserdata);
            }
        }
        msg.setHexPassword(HexUtils.bytes2HexString((byte[])Password));
        ParamEpcFilter filter = new ParamEpcFilter();
        filter.setArea(FilterArea);
        filter.setHexData(Str);
        filter.setBitStart(FilterArea == 1 ? 32 : 0);
        filter.setBitLength(Str.length() * 4);
        msg.setFilter(filter);
        this.client.sendSynMsg((Message)msg);
        if (msg.getRtCode() != 0) {
            return String.format("%2X", msg.getRtCode());
        }
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            try {
                this.lock.wait(2000L);
                MsgBaseStop stop = new MsgBaseStop();
                this.client.sendSynMsg((Message)stop);
                // ** MonitorExit[var9_9] (shouldn't be in output)
                return this.singleData;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String ReadDataByEPC(String EPCStr, byte Mem, int WordPtr, byte Num, byte[] Password) {
        return this.ReadDataFilter(1, EPCStr, Mem, WordPtr, Num, Password);
    }

    @Override
    public String ReadDataByTID(String TIDStr, byte Mem, int WordPtr, byte Num, byte[] Password) {
        return this.ReadDataFilter(2, TIDStr, Mem, WordPtr, Num, Password);
    }

    public int WriteDataFilter(int FilterArea, String Str, byte Mem, int WordPtr, byte[] Password, String wdata) {
        MsgBaseWriteEpc msg = new MsgBaseWriteEpc();
        msg.setAntennaEnable(Long.valueOf(1L));
        msg.setArea((int)Mem);
        msg.setStart(WordPtr == 0 ? 1 : WordPtr);
        msg.setHexPassword(HexUtils.bytes2HexString((byte[])Password));
        Log.e((String)this.TAG, (String)("WriteDataFilter00: wdata --> " + wdata));
        int valueLen = PcUtils.getValueLen(wdata);
        Log.e((String)this.TAG, (String)("WriteDataFilter: valueLen --> " + valueLen));
        if (Mem == 1 && WordPtr >= 1) {
            String pc = PcUtils.getPc(valueLen);
            Log.e((String)this.TAG, (String)("WriteDataFilter: pc -->" + pc));
            wdata = pc + PcUtils.padLeft(wdata, valueLen, '0');
            Log.e((String)this.TAG, (String)("WriteDataFilter01: wdata -->" + wdata));
        } else if (Mem == 3 && WordPtr >= 1) {
            wdata = PcUtils.padLeft(wdata, valueLen, '0');
        } else {
            return -1;
        }
        msg.setHexWriteData(wdata);
        ParamEpcFilter filter = new ParamEpcFilter();
        filter.setArea(FilterArea);
        filter.setHexData(Str);
        filter.setBitStart(FilterArea == 1 ? 32 : 0);
        filter.setBitLength(Str.length() * 4);
        msg.setFilter(filter);
        this.client.sendSynMsg((Message)msg);
        Log.e((String)"WriteDataFilter", (String)("MsgBaseWriteEpc " + msg.getRtCode() + "=" + msg.getRtMsg()));
        return msg.getRtCode();
    }

    @Override
    public int WriteDataByEPC(String EPCStr, byte Mem, int WordPtr, byte[] Password, String wdata) {
        return this.WriteDataFilter(1, EPCStr, Mem, WordPtr, Password, wdata);
    }

    @Override
    public int WriteDataByTID(String TIDStr, byte Mem, byte WordPtr, byte[] Password, String wdata) {
        return this.WriteDataFilter(2, TIDStr, Mem, WordPtr, Password, wdata);
    }

    @Override
    public int WriteEPCByTID(String TIDStr, String EPCStr, byte[] Password) {
        return this.WriteDataFilter(2, TIDStr, (byte)1, 1, Password, EPCStr);
    }

    @Override
    public int Lock(String EPCStr, byte select, byte setprotect, String PasswordStr) {
        this.client.sendUnsynMsg((Message)new MsgBaseStop());
        MsgBaseWriteEpc writePas = new MsgBaseWriteEpc();
        ParamEpcFilter filter = new ParamEpcFilter();
        filter.setArea(1);
        filter.setBitStart(32);
        filter.setBitLength(EPCStr.length() * 4);
        filter.setHexData(EPCStr);
        writePas.setFilter(filter);
        if (setprotect != 0 && setprotect != 1) {
            writePas.setAntennaEnable(Long.valueOf(1L));
            writePas.setArea(0);
            writePas.setStart(2);
            writePas.setHexWriteData(PasswordStr);
            writePas.setFilter(filter);
            this.client.sendSynMsg((Message)writePas);
            if (writePas.getRtCode() != 0) {
                Log.e((String)"Lock", (String)("WritePws Failed " + writePas.getRtMsg()));
                return writePas.getRtCode();
            }
        } else {
            writePas.setRtCode((byte)0);
        }
        MsgBaseLockEpc msg = new MsgBaseLockEpc();
        msg.setAntennaEnable(Long.valueOf(1L));
        msg.setArea((int)select);
        switch (setprotect) {
            case 0: {
                msg.setMode(0);
                break;
            }
            case 1: {
                msg.setMode(2);
                break;
            }
            case 2: {
                msg.setMode(1);
                break;
            }
            case 3: {
                msg.setMode(3);
            }
        }
        msg.setHexPassword(PasswordStr);
        msg.setFilter(filter);
        this.client.sendSynMsg((Message)msg);
        Log.e((String)"Lock", (String)("Lock [" + msg.getRtCode() + "] [" + msg.getRtMsg() + "]"));
        return msg.getRtCode();
    }

    @Override
    public int Kill(String EPCStr, String PasswordStr) {
        this.client.sendUnsynMsg((Message)new MsgBaseStop());
        MsgBaseWriteEpc writePas = new MsgBaseWriteEpc();
        writePas.setAntennaEnable(Long.valueOf(1L));
        writePas.setArea(0);
        writePas.setStart(0);
        writePas.setHexWriteData(PasswordStr);
        ParamEpcFilter filter = new ParamEpcFilter();
        filter.setArea(1);
        filter.setBitStart(32);
        filter.setBitLength(EPCStr.length() * 4);
        filter.setHexData(EPCStr);
        writePas.setFilter(filter);
        this.client.sendSynMsg((Message)writePas);
        if (writePas.getRtCode() != 0) {
            Log.e((String)"Kill", (String)("WritePws Failed " + writePas.getRtMsg()));
            return writePas.getRtCode();
        }
        MsgBaseDestroyEpc msg = new MsgBaseDestroyEpc();
        msg.setAntennaEnable(Long.valueOf(1L));
        msg.setHexPassword(PasswordStr);
        msg.setFilter(filter);
        this.client.sendSynMsg((Message)msg);
        Log.e((String)"Kill", (String)("Destroy [" + msg.getRtCode() + "] [" + msg.getRtMsg() + "]"));
        return msg.getRtCode();
    }

    @Override
    public void SetCallBack(TagCallback callback) {
        this.callback = callback;
    }

    @Override
    public int StartRead() {
        this.client.sendUnsynMsg((Message)new MsgBaseStop());
        this.onLoopCallback();
        MsgBaseGetBaseband getBaseBand = new MsgBaseGetBaseband();
        this.client.sendSynMsg((Message)getBaseBand);
        if (getBaseBand.getRtCode() != 0) {
            Log.e((String)"StartRead", (String)"getBaseBand Failed");
            return getBaseBand.getRtCode();
        }
        if (getBaseBand.getqValue() != this.param.QValue || getBaseBand.getSession() != this.param.Session) {
            MsgBaseSetBaseband setBaseBand = new MsgBaseSetBaseband();
            setBaseBand.setqValue(this.param.QValue);
            setBaseBand.setSession(this.param.Session);
            this.client.sendSynMsg((Message)setBaseBand);
            if (setBaseBand.getRtCode() != 0) {
                Log.e((String)"StartRead", (String)"SetBaseBand Failed");
                return setBaseBand.getRtCode();
            }
        }
        MsgBaseInventoryEpc msg = new MsgBaseInventoryEpc();
        msg.setAntennaEnable(Long.valueOf(1L));
        msg.setInventoryMode(1);
        if (this.param.TidLen > 0) {
            ParamEpcReadTid readTid = new ParamEpcReadTid();
            readTid.setMode(1);
            readTid.setLen(this.param.TidLen);
            msg.setReadTid(readTid);
        }
        this.client.sendSynMsg((Message)msg);
        Log.e((String)"StartRead", (String)("Inventory [" + msg.getRtCode() + "] [" + msg.getRtMsg() + "]"));
        return msg.getRtCode();
    }

    @Override
    public void StopRead() {
        this.isSound = false;
        MsgBaseStop stop = new MsgBaseStop();
        this.client.sendSynMsg((Message)stop);
        Log.d((String)this.TAG, (String)("StopRead: ===========stop.getRtCode()==" + stop.getRtCode()));
    }

    @Override
    public List<InventoryTagMap> getInventoryTagMapList() {
        return lsTagList;
    }

    @Override
    public List<InventoryTagResult> getInventoryTagResultList() {
        return lsList;
    }

    @Override
    public int RfOutput(byte OnOff) {
        return 0;
    }

    @Override
    public int SetPowerMode(int OnOff) {
        OnOff |= 0x80;
        return 0;
    }

    @Override
    public int MeasureTemperature(byte[] Temp) {
        return 0;
    }

    @Override
    public int MeasureReturnLoss(byte[] ReturnLoss) {
        MsgTestCarrierWave carrierWave = new MsgTestCarrierWave();
        carrierWave.setAntennaNum(Long.valueOf(1L));
        carrierWave.setFreqCursor(0);
        this.client.sendSynMsg((Message)carrierWave);
        if (carrierWave.getRtCode() == 0) {
            MsgTestVSWRcheck rcheck = new MsgTestVSWRcheck();
            this.client.sendSynMsg((Message)rcheck);
            if (rcheck.getRtCode() == 0) {
                ReturnLoss[0] = (byte)rcheck.getSufValue();
                return rcheck.getRtCode();
            }
        }
        return carrierWave.getRtCode();
    }

    @Override
    public int SetAntenna(byte AntCfg) {
        return 0;
    }

    @Override
    public int SetBeepNotification(int BeepEn) {
        return 0;
    }

    @Override
    public int SetWorkMode(byte ReadMode) {
        return 0;
    }

    @Override
    public int SetBaudRate(byte BaudTate) {
        return 0;
    }

    @Override
    public int GetModuleVersion() {
        return 1;
    }

    @Override
    public void singleRead() {
        this.StartRead();
        try {
            Thread.sleep(1500L);
            this.StopRead();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setBeepSuccess(int mode) {
    }

    @Override
    public void setTagDataList(List<TagData> tagDataList) {
    }

    @Override
    public List<TagData> getTagDataList() {
        return null;
    }

    @Override
    public List<TagData> getFilterTags() {
        return null;
    }

    @Override
    public void setQueryInfo(QueryInfo queryInfo) {
    }

    @Override
    public QueryInfo getQueryInfo() {
        return null;
    }

    @Override
    public BaseInfo getBaseInfo() {
        return null;
    }
}

