/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Parameter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;

public class ParamEncipheredData
extends Parameter {
    private int bitLength;
    private String hexData;
    private byte[] bData;

    public ParamEncipheredData() {
    }

    public ParamEncipheredData(int bitLength, String hexData) {
        this.bitLength = bitLength;
        this.hexData = hexData;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public void setBitLength(int bitLength) {
        this.bitLength = bitLength;
    }

    public String getHexData() {
        return this.hexData;
    }

    public void setHexData(String hexData) {
        if (!StringUtils.isNullOfEmpty(hexData)) {
            this.hexData = hexData;
            this.bData = HexUtils.hexString2Bytes(this.hexData);
        }
    }

    public byte[] getbData() {
        return this.bData;
    }

    public void setbData(byte[] bData) {
        this.bData = bData;
    }

    public ParamEncipheredData(byte[] data) {
        if (null == data) {
            return;
        }
        try {
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.bitLength = buffer.getIntUnsigned(16);
            int byteLength = this.bitLength / 8;
            this.bData = new byte[byteLength];
            if (byteLength > 0) {
                this.bData = buffer.get(this.bData);
                this.hexData = HexUtils.bytes2HexString(this.bData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte[] toBytes() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.bitLength, 16);
        buffer.put(this.bData);
        return buffer.asByteArray();
    }
}

