/*
 * Decompiled with CFR 0.152.
 */
package me.weyye.hipermission;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ListAdapter;
import java.util.List;
import java.util.ListIterator;
import me.weyye.hipermission.PermissionAdapter;
import me.weyye.hipermission.PermissionCallback;
import me.weyye.hipermission.PermissionItem;
import me.weyye.hipermission.PermissionView;
import me.weyye.hipermission.R;

public class PermissionActivity
extends AppCompatActivity {
    public static int PERMISSION_TYPE_SINGLE = 1;
    public static int PERMISSION_TYPE_MUTI = 2;
    private int mPermissionType;
    private String mTitle;
    private String mMsg;
    private static PermissionCallback mCallback;
    private List<PermissionItem> mCheckPermissions;
    private Dialog mDialog;
    private static final int REQUEST_CODE_SINGLE = 1;
    private static final int REQUEST_CODE_MUTI = 2;
    public static final int REQUEST_CODE_MUTI_SINGLE = 3;
    private static final int REQUEST_SETTING = 110;
    private static final String TAG = "PermissionActivity";
    private CharSequence mAppName;
    private int mStyleId;
    private int mFilterColor;
    private int mAnimStyleId;
    private int mRePermissionIndex;

    public static void setCallBack(PermissionCallback callBack) {
        mCallback = callBack;
    }

    protected void onDestroy() {
        super.onDestroy();
        mCallback = null;
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getDatas();
        if (this.mPermissionType == PERMISSION_TYPE_SINGLE) {
            if (this.mCheckPermissions == null || this.mCheckPermissions.size() == 0) {
                return;
            }
            this.requestPermission(new String[]{this.mCheckPermissions.get((int)0).Permission}, 1);
        } else {
            this.mAppName = this.getApplicationInfo().loadLabel(this.getPackageManager());
            this.showPermissionDialog();
        }
    }

    private String getPermissionTitle() {
        return TextUtils.isEmpty((CharSequence)this.mTitle) ? String.format(this.getString(R.string.permission_dialog_title), this.mAppName) : this.mTitle;
    }

    private void showPermissionDialog() {
        String title = this.getPermissionTitle();
        String msg = TextUtils.isEmpty((CharSequence)this.mMsg) ? String.format(this.getString(R.string.permission_dialog_msg), this.mAppName) : this.mMsg;
        PermissionView contentView = new PermissionView((Context)this);
        contentView.setGridViewColum(this.mCheckPermissions.size() < 3 ? this.mCheckPermissions.size() : 3);
        contentView.setTitle(title);
        contentView.setMsg(msg);
        contentView.setGridViewAdapter((ListAdapter)new PermissionAdapter(this.mCheckPermissions));
        if (this.mStyleId == -1) {
            this.mStyleId = R.style.PermissionDefaultNormalStyle;
            this.mFilterColor = this.getResources().getColor(R.color.permissionColorGreen);
        }
        contentView.setStyleId(this.mStyleId);
        contentView.setFilterColor(this.mFilterColor);
        contentView.setBtnOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PermissionActivity.this.mDialog != null && PermissionActivity.this.mDialog.isShowing()) {
                    PermissionActivity.this.mDialog.dismiss();
                }
                String[] strs = PermissionActivity.this.getPermissionStrArray();
                ActivityCompat.requestPermissions((Activity)PermissionActivity.this, (String[])strs, (int)2);
            }
        });
        this.mDialog = new Dialog((Context)this);
        this.mDialog.requestWindowFeature(1);
        this.mDialog.setContentView((View)contentView);
        if (this.mAnimStyleId != -1) {
            this.mDialog.getWindow().setWindowAnimations(this.mAnimStyleId);
        }
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                dialog.dismiss();
                if (mCallback != null) {
                    mCallback.onClose();
                }
                PermissionActivity.this.finish();
            }
        });
        this.mDialog.show();
    }

    private void reRequestPermission(final String permission2) {
        String permissionName = this.getPermissionItem((String)permission2).PermissionName;
        String alertTitle = String.format(this.getString(R.string.permission_title), permissionName);
        String msg = String.format(this.getString(R.string.permission_denied), permissionName, this.mAppName);
        this.showAlertDialog(alertTitle, msg, this.getString(R.string.permission_cancel), this.getString(R.string.permission_ensure), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PermissionActivity.this.requestPermission(new String[]{permission2}, 3);
            }
        });
    }

    private void requestPermission(String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)requestCode);
    }

    private void showAlertDialog(String title, String msg, String cancelTxt, String PosTxt, DialogInterface.OnClickListener onClickListener) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)title).setMessage((CharSequence)msg).setCancelable(false).setNegativeButton((CharSequence)cancelTxt, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PermissionActivity.this.onClose();
            }
        }).setPositiveButton((CharSequence)PosTxt, onClickListener).create();
        alertDialog.show();
    }

    private String[] getPermissionStrArray() {
        String[] str = new String[this.mCheckPermissions.size()];
        for (int i = 0; i < this.mCheckPermissions.size(); ++i) {
            str[i] = this.mCheckPermissions.get((int)i).Permission;
        }
        return str;
    }

    private void getDatas() {
        Intent intent = this.getIntent();
        this.mPermissionType = intent.getIntExtra("data_permission_type", PERMISSION_TYPE_SINGLE);
        this.mTitle = intent.getStringExtra("data_title");
        this.mMsg = intent.getStringExtra("data_msg");
        this.mFilterColor = intent.getIntExtra("data_color_filter", 0);
        this.mStyleId = intent.getIntExtra("data_style_id", -1);
        this.mAnimStyleId = intent.getIntExtra("data_anim_style", -1);
        this.mCheckPermissions = (List)((Object)intent.getSerializableExtra("data_permissions"));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                String permission2 = this.getPermissionItem((String)permissions[0]).Permission;
                if (grantResults[0] == 0) {
                    this.onGuarantee(permission2, 0);
                } else {
                    this.onDeny(permission2, 0);
                }
                this.finish();
                break;
            }
            case 2: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] == 0) {
                        PermissionItem item = this.getPermissionItem(permissions[i]);
                        this.mCheckPermissions.remove(item);
                        this.onGuarantee(permissions[i], i);
                        continue;
                    }
                    this.onDeny(permissions[i], i);
                }
                if (this.mCheckPermissions.size() > 0) {
                    this.reRequestPermission(this.mCheckPermissions.get((int)this.mRePermissionIndex).Permission);
                    break;
                }
                this.onFinish();
                break;
            }
            case 3: {
                if (grantResults[0] == -1) {
                    try {
                        String name = this.getPermissionItem((String)permissions[0]).PermissionName;
                        String title = String.format(this.getString(R.string.permission_title), name);
                        String msg = String.format(this.getString(R.string.permission_denied_with_naac), this.mAppName, name, this.mAppName);
                        this.showAlertDialog(title, msg, this.getString(R.string.permission_reject), this.getString(R.string.permission_go_to_setting), new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialog, int which) {
                                try {
                                    Uri packageURI = Uri.parse((String)("package:" + PermissionActivity.this.getPackageName()));
                                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageURI);
                                    PermissionActivity.this.startActivityForResult(intent, 110);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    PermissionActivity.this.onClose();
                                }
                            }
                        });
                        this.onDeny(permissions[0], 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.onClose();
                    }
                    break;
                }
                this.onGuarantee(permissions[0], 0);
                if (this.mRePermissionIndex < this.mCheckPermissions.size() - 1) {
                    this.reRequestPermission(this.mCheckPermissions.get((int)(++this.mRePermissionIndex)).Permission);
                    break;
                }
                this.onFinish();
            }
        }
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    public void onBackPressed() {
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.e((String)TAG, (String)("onActivityResult--requestCode:" + requestCode + ",resultCode:" + resultCode));
        if (requestCode == 110) {
            if (this.mDialog != null && this.mDialog.isShowing()) {
                this.mDialog.dismiss();
            }
            this.checkPermission();
            if (this.mCheckPermissions.size() > 0) {
                this.mRePermissionIndex = 0;
                this.reRequestPermission(this.mCheckPermissions.get((int)this.mRePermissionIndex).Permission);
            } else {
                this.onFinish();
            }
        }
    }

    private void checkPermission() {
        ListIterator<PermissionItem> iterator = this.mCheckPermissions.listIterator();
        while (iterator.hasNext()) {
            int checkPermission = ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)iterator.next().Permission);
            if (checkPermission != 0) continue;
            iterator.remove();
        }
    }

    private void onFinish() {
        if (mCallback != null) {
            mCallback.onFinish();
        }
        this.finish();
    }

    private void onClose() {
        if (mCallback != null) {
            mCallback.onClose();
        }
        this.finish();
    }

    private void onDeny(String permission2, int position) {
        if (mCallback != null) {
            mCallback.onDeny(permission2, position);
        }
    }

    private void onGuarantee(String permission2, int position) {
        if (mCallback != null) {
            mCallback.onGuarantee(permission2, position);
        }
    }

    private PermissionItem getPermissionItem(String permission2) {
        for (PermissionItem permissionItem : this.mCheckPermissions) {
            if (!permissionItem.Permission.equals(permission2)) continue;
            return permissionItem;
        }
        return null;
    }
}

