/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetReaderInfo
extends Message {
    private String readerSerialNumber;
    private long powerOnTime;
    private String baseCompileTime;
    private String appVersions;
    private String systemVersions;
    private String appCompileTime;

    public MsgAppGetReaderInfo() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = 0;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetReaderInfo(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            int snLen = buffer.getIntUnsigned(16);
            if (snLen > 0) {
                this.readerSerialNumber = new String(buffer.get(new byte[snLen]), "ASCII");
            }
            this.powerOnTime = buffer.getLongUnsigned(32);
            int btLen = buffer.getIntUnsigned(16);
            if (btLen > 0) {
                this.baseCompileTime = new String(buffer.get(new byte[btLen]), "ASCII");
            }
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.appVersions = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        int svLen = buffer.getIntUnsigned(16);
                        if (svLen <= 0) break;
                        this.systemVersions = new String(buffer.get(new byte[svLen]), "ASCII");
                        break;
                    }
                    case 3: {
                        int atLen = buffer.getIntUnsigned(16);
                        if (atLen <= 0) break;
                        this.appCompileTime = new String(buffer.get(new byte[atLen]), "ASCII");
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getAppVersions() {
        return this.appVersions;
    }

    public void setAppVersions(String appVersions) {
        this.appVersions = appVersions;
    }

    public String getSystemVersions() {
        return this.systemVersions;
    }

    public void setSystemVersions(String systemVersions) {
        this.systemVersions = systemVersions;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    public long getPowerOnTime() {
        return this.powerOnTime;
    }

    public void setPowerOnTime(long powerOnTime) {
        this.powerOnTime = powerOnTime;
    }

    public String getBaseCompileTime() {
        return this.baseCompileTime;
    }

    public void setBaseCompileTime(String baseCompileTime) {
        this.baseCompileTime = baseCompileTime;
    }

    public String getAppCompileTime() {
        return this.appCompileTime;
    }

    public void setAppCompileTime(String appCompileTime) {
        this.appCompileTime = appCompileTime;
    }

    public String getFormatPowerOnTime() {
        long microseconds = this.getPowerOnTime() * 1000L;
        long days = microseconds / 86400000L;
        long hours = microseconds % 86400000L / 3600000L;
        long minutes = microseconds % 3600000L / 60000L;
        long seconds = microseconds % 60000L / 1000L;
        return days + " days " + hours + " hours " + minutes + " minutes " + seconds + " seconds ";
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (null != this.readerSerialNumber) {
                buffer.putInt(this.readerSerialNumber.length(), 16);
                buffer.put(this.readerSerialNumber);
            }
            buffer.put(this.powerOnTime, 32);
            if (null != this.baseCompileTime) {
                buffer.putInt(this.baseCompileTime.length(), 16);
                buffer.put(this.baseCompileTime);
            }
            if (null != this.appVersions) {
                String[] visions;
                buffer.putInt(1, 8);
                for (String vs : visions = this.appVersions.split("\\.")) {
                    buffer.putInt(Integer.parseInt(vs), 8);
                }
            }
            if (null != this.systemVersions) {
                buffer.putInt(2, 8);
                buffer.putInt(this.systemVersions.length(), 16);
                buffer.put(this.systemVersions);
            }
            if (null != this.appCompileTime) {
                buffer.putInt(3, 8);
                buffer.putInt(this.appCompileTime.length(), 16);
                buffer.put(this.appCompileTime);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            try {
                int snLen = buffer.getIntUnsigned(16);
                if (snLen > 0) {
                    this.readerSerialNumber = new String(buffer.get(new byte[snLen]), "ASCII");
                }
                this.powerOnTime = buffer.getLongUnsigned(32);
                int btLen = buffer.getIntUnsigned(16);
                if (btLen > 0) {
                    this.baseCompileTime = new String(buffer.get(new byte[btLen]), "ASCII");
                }
                while (buffer.position() / 8 < this.cData.length) {
                    byte pid = buffer.getByte();
                    switch (pid) {
                        case 1: {
                            this.appVersions = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                            break;
                        }
                        case 2: {
                            int svLen = buffer.getIntUnsigned(16);
                            if (svLen <= 0) break;
                            this.systemVersions = new String(buffer.get(new byte[svLen]), "ASCII");
                            break;
                        }
                        case 3: {
                            int atLen = buffer.getIntUnsigned(16);
                            if (atLen <= 0) break;
                            this.appCompileTime = new String(buffer.get(new byte[atLen]), "ASCII");
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetReaderInfo{readerSerialNumber='" + this.readerSerialNumber + '\'' + ", powerOnTime=" + this.powerOnTime + ", baseCompileTime='" + this.baseCompileTime + '\'' + ", appVersions='" + this.appVersions + '\'' + ", systemVersions='" + this.systemVersions + '\'' + ", appCompileTime='" + this.appCompileTime + '\'' + '}';
    }
}

