/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.SimpleBitBuffer;

public class ArrayBitBuffer
extends SimpleBitBuffer {
    private byte[] bytes;

    protected ArrayBitBuffer(byte[] bytes, int limit, int offset) {
        this.bytes = bytes;
        this.limit = limit;
        this.offset = offset;
        this.size = limit;
    }

    protected ArrayBitBuffer(int bits) {
        this.bytes = new byte[(int)(((long)bits + (8L - (long)bits % 8L)) / 8L)];
        this.size = this.limit = bits;
    }

    protected ArrayBitBuffer(byte[] bytes) {
        this.bytes = bytes;
        this.size = this.limit = bytes.length * 8;
    }

    @Override
    protected byte rawGet(int index) {
        return this.bytes[index];
    }

    @Override
    protected void rawSet(int index, byte value) {
        this.bytes[index] = value;
    }

    @Override
    protected int rawLength() {
        return this.limit;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public BitBuffer slice() {
        return new ArrayBitBuffer(this.bytes, this.size() - this.position(), this.offset + this.position());
    }

    @Override
    public BitBuffer slice(int start, int length) {
        return new ArrayBitBuffer(this.bytes, Math.min(length, this.size() - start), this.offset + start);
    }

    @Override
    public BitBuffer slice(int start) {
        return this.slice(start, this.size() - start);
    }
}

